# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::MacRegistration::WMBRegistration;

use Clarity -base;

use constant false => 0;
use constant true  => 1;

field name;
field mac1;
field mac2;
field street;
field vlanName;

sub new
{
	my($class, $name, $mac1, $mac2, $regDate, $vlanName) = @_;

	return super(
		name => $name,
		mac1 => $mac1,
		mac2 => $mac2,
		regDate => $regDate,
		vlanName => $vlanName,
	);
}

sub hasMACAddress
{
    my ($self, $mac) = @_;

	return unless defined $mac;

    if ($mac ne "" && ($mac eq $self->mac1 || $mac eq $self->mac2))
	{
		return defined $mac;
	}
}

sub equals
{
	my ($self, $registration) = @_;

	if (defined($registration))
	{
		foreach my $reg ($self->getRegistrations())
		{
		   if ($registration->name eq $reg->name &&
			   $registration->mac1 eq $reg->mac1 &&
			   $registration->mac2 eq $reg->mac2 &&
			   $registration->regDate eq $reg->regDate &&
			   $registration->regDate eq $reg->regDate &&
			   $registration->vlanName eq $reg->vlanName
			  ) { return true };
		}
	}
}

sub toString
{
        my ($self) = @_;

        return "name=" . $self->name . ", mac1=" . $self->mac1 . ", mac2=" . $self->mac2 . ", regDate=" . $self->regDate . ", vlanName=" . $self->vlanName;
}

use overload '""' => \&toString;

1;
