# $Id: Config.pm 8286 2013-09-12 08:26:11Z hurko $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/libuvt-noc-perl/lib/UvT/NOC/Config.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::NOC::Config;

use Clarity -base;

use XML::LibXML;

use UvT::NOC::Config::ResourceList;
use UvT::NOC::Config::Resource;
use UvT::NOC::Config::ResourceFileList;
use UvT::NOC::Config::ResourceFile;
use UvT::NOC::Config::Property;

field configfile;
field doc;

sub new
{
	my($class, $configfile) = @_;

	return super(
		configfile => $configfile,
		doc => XML::LibXML->new()->parse_file($configfile)
	);
}

sub getFile
{
	my($self, $name) = @_;
	my $doc = $self->doc;

	my $file = undef;

	die "Cannot find node 'files'\n"
		unless $doc->exists('/config/files');

	foreach my $fileNode ($doc->findnodes('/config/files/file'))
	{
		if ($fileNode->getAttribute('name') eq $name)
		{
			# print "Found node with name : " . $fileNode->getAttribute('name') . "\n";
			$file = $fileNode->textContent;
		}
	}

	die "Cannot find file node with name $name\n"
		unless defined $file;

	return $file;
}

sub getDirectory
{
	my($self, $name) = @_;
	my $doc = $self->doc;

	my $directory = undef;

	die "Cannot find node 'directories'\n"
		unless $doc->exists('/config/directories');

	foreach my $directoryNode ($doc->findnodes('/config/directories/directory'))
	{
		if ($directoryNode->getAttribute('name') eq $name)
		{
			# print "Found node with name : " . $directoryNode->getAttribute('name') . "\n";
			$directory = $directoryNode->textContent;
		}
	}

	die "Cannot find directory node with name $name\n"
		unless defined $directory;

	return $directory;
}

sub getResources
{
	my ($self) = @_;
	my $doc = $self->doc;

	my $resources = new UvT::NOC::Config::ResourceList();

	die "Cannot find node 'resources'\n"
		unless $doc->exists('/config/resources');

	foreach my $resourceNode ($doc->findnodes('/config/resources/resource'))
	{
		my $resourceName = $resourceNode->getAttribute('name');
		# print "-- > $resourceName\n";
		my $resource = new UvT::NOC::Config::Resource($resourceName);

		foreach my $propertyNode ($resourceNode->findnodes('property'))
		{
			#print Dumper($propertyNode->toString(1));
			my $propertyName = $propertyNode->getAttribute('name');
			my $propertyValue = $propertyNode->textContent;
			#print "\t$propertyName\t\t$propertyValue\n";

			my $property = new UvT::NOC::Config::Property($propertyName, $propertyValue);
			$resource->addProperty($property);
		}
		$resources->addResource($resource);
	}

	return $resources; 
}

sub getResourceFiles
{
	my ($self) = @_;
    my $doc = $self->doc;

    my $resourceFiles = new UvT::NOC::Config::ResourceFileList();

    die "Cannot find node 'resourceFiles'\n"
            unless $doc->exists('/config/resourceFiles');

    foreach my $resourceFileNode ($doc->findnodes('/config/resourceFiles/resourceFile'))
    {
		my $resourceFileName = $resourceFileNode->getAttribute('name');
        # print "-- > $resourceFileName\n";
        my $resourceFile = new UvT::NOC::Config::ResourceFile($resourceFileName);

        foreach my $propertyNode ($resourceFileNode->findnodes('property'))
        {
		    #print Dumper($propertyNode->toString(1));
		    my $propertyName = $propertyNode->getAttribute('name');
		    my $propertyValue = $propertyNode->textContent;
		    #print "\t$propertyName\t\t$propertyValue\n";

		    my $property = new UvT::NOC::Config::Property($propertyName, $propertyValue);
		    $resourceFile->addProperty($property);
        }
        $resourceFiles->addResourceFile($resourceFile);
    }

    return $resourceFiles;
}

1;




