# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::Config::Property;

use Clarity -base;

field name;
field value;

sub new
{
	my($class, $name, $value) = @_;

	return super(
		name => $name,
		value => $value
	);
}

sub getName
{
        my ($self) = @_;

        return $self->name;
}

sub getValue
{
        my ($self) = @_;

        return $self->value;
}

sub toString
{
	my ($self) = @_;

	return "name=" . $self->name . ", value=" . $self->value;
}

use overload '""' => \&toString;

1;
