# $Id$
# $URL$

use strict;
use warnings FATAL => 'all';

package UvT::NOC::Config::ResourceFileList;

use UvT::NOC::Config::ResourceFile;
use Data::Dumper;

use Clarity -base;

field resourceFiles => {};

sub addResourceFile
{
    my ($self, $resourceFile) = @_;

    return unless defined $resourceFile;

    if($self->hasResourceFile($resourceFile))
	{
        warn("### Warning : ResourceFile '" . $resourceFile->name . "' already exists in ResourceFilesList! ResourceFile not added!");
        return;
    }

	$self->resourceFiles->{$resourceFile->name} = $resourceFile;
}

sub removeResourceFile
{
	my ($self, $resourceFile) = @_;

	return unless defined $resourceFile;

	my $name = ref $resourceFile ? $resourceFile->name : $resourceFile;

	delete $self->resourceFiles->{$name};
}

sub hasResourceFile
{
	my ($self, $resourceFile) = @_;

	my $resourceFileName = ref $resourceFile ? $resourceFile->name : $resourceFile;

	return defined $self->getResourceFile($resourceFileName);
}

sub getResourceFile
{
	my ($self, $name) = @_;

	return unless defined $name;

	return $self->resourceFiles->{$name};
}

sub getResourceFiles
{
    my ($self) = @_;

	return values %{$self->resourceFiles};
}

sub removeAllResourceFiles
{
    my ($self) = @_;

    delete $self->{resourceFiles};
}

sub size
{
    my ($self) = @_;

    return scalar keys %{$self->resourceFiles};
}

sub toString
{
	my($self) = @_;
    my $string = "";

    my @resourceFiles = $self->getResourceFiles();
    for my $i (0..$#resourceFiles)
    {
        $string .= "resourceFile=[" . $resourceFiles[$i]->toString() . "]" . ( $i < $#resourceFiles ? "\n" : ""); 
    }

    return $string;
}

use overload '""' => \&toString;

1;

