use strict;
use warnings FATAL => 'all';

package UvT::NOC::Net::SMTP;

use Net::SMTP;
use Exporter qw(import);

our @EXPORT = qw(sendMail);
our @EXPORT_OK = @EXPORT;


sub sendMail
{
        my $mailHost = shift;
        my $mailFrom = shift;
        my $mailFromFullName = shift;
        my $mailTo = shift;
        my $mailSubject = shift;
        my $mailBody = shift;

        my $smtp = Net::SMTP->new($mailHost) or die "Could not connect to server : $!";
        $smtp->mail($mailFrom);
        $smtp->to($mailTo);
        $smtp->data();

        # SMTP headers
        $smtp->datasend("To: $mailTo\n");
        $smtp->datasend("From: $mailFromFullName<$mailFrom>\n");
        $smtp->datasend("Subject: $mailSubject\n");

        # Line break to separate headers from message body
        $smtp->datasend("\n");

        # Message body
        $smtp->datasend($mailBody);
        $smtp->datasend("\n");
        $smtp->dataend;
        $smtp->quit;
}

