use strict;
use warnings FATAL => 'all';

package UvT::NOC::Net::SMTP;

use Net::SMTP;
use MIME::Base64;
use Clarity -base;

field host;
field from;
field fromFullName;
field to;
field subject;
field body;
field attachments;

sub new
{
	my($class, $host, $from, $fromFullName, $to) = @_;

	return super(
		host => $host,
		from => $from,
		fromFullName => $fromFullName,
		to => $to,
		subject => "",
		body => "",
		attachments => {},
	);
}

sub send()
{
	my ($self) = @_;

	my $boundary = "==MESSAGE-BOUNDARY-NOC-" .time();

	my $smtp = Net::SMTP->new($self->host) or die "Could not connect to server : $!";
	$smtp->mail($self->from);
	$smtp->to($self->to);
	$smtp->data();

	# SMTP headers
	$smtp->datasend("To: ". $self->to . "\n");
	$smtp->datasend("From: " . $self->fromFullName . " <" . $self->from . ">\n");
	$smtp->datasend("Subject: " . $self->subject . "\n");
	$smtp->datasend("MIME-Version: 1.0\n");
	
	if ($self->size() > 0)
	{
		# Attachments exists -> set content-type to multipart
		$smtp->datasend("Content-type: multipart/mixed; boundary=\"" . $boundary . "\"\n");
#		$smtp->datasend("\n");
#		$smtp->datasend("This is a multi-part message in MIME format.\n");
	}
    
	# Line break to separate headers from message body
	$smtp->datasend("\n");


	# Message body
	if ($self->size() > 0)
	{
		# Attachments exists -> plaintext boundary
		$smtp->datasend("--" . $boundary . "\n");
		$smtp->datasend("Content-Transfer-Encoding: 8bit\n");
		$smtp->datasend("Content-type: text/plain; charset=us-ascii; charset=UTF-8;\n");
		$smtp->datasend("\n");
	}

	$smtp->datasend($self->body);
	$smtp->datasend("\n");

	if ($self->size() > 0)
	{
		# Attachments exists -> add those attachments
		my @attachments = $self->getAttachments();
		for my $i (0..$#attachments)
		{
			my $attachment = $attachments[$i];

			$smtp->datasend("--" . $boundary . "\n");
			$smtp->datasend("Content-Transfer-Encoding: base64\n");
			$smtp->datasend("Content-Type: " . $attachment->{contentType} . "\n name=" . $attachment->{filename} . "\n");
			$smtp->datasend("Content-Disposition: attachment;\n filename=" . $attachment->{filename} . "\n");
			$smtp->datasend("\n");
			$smtp->datasend(encode_base64($attachment->{file}));
		}

		# Attachments exists -> end boundary ( let op de eind streepjes :) )
		$smtp->datasend("--" . $boundary . "--\n");
	}

	$smtp->dataend;
	$smtp->quit;
}

sub addAttachment
{
	my ($self, $filename, $contentType, $file) = @_;

	$self->attachments->{$filename} = { filename => $filename, contentType => $contentType, file => $file };
}

sub size
{
	my ($self) = @_;

	return scalar keys %{$self->attachments};
}

sub getAttachments
{
	my ($self) = @_;

	return values %{$self->attachments};
}

use overload '""' => \&toString;

1;

