# $Id: StringUtil.pm 6701 2012-10-09 12:24:35Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/libnoc-infra-perl/lib/NOC/Util/StringUtil.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::NOC::Util::StringUtil;

use Exporter qw(import);

our @EXPORT = qw(trim removeQuotes stringReplace);
our @EXPORT_OK = @EXPORT;


# Functienaam : trim
#
# Parameters : (1x)
#       1) de string die 'getrimd' dient te worden
#
# Omschrijving :
#       Trim-functie voor het verwijderen van de spaties aan begin en het einde van een string
#       Word overbodig in Perl6, vanaf versie 6 heeft Perl namelijk wel een trim-functie aan boord

sub trim
{
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}


# Functienaam  : removequotes
#
# Parameters : (1x)
#       1) de string die 'ge-unquote' dient te worden
#
# Omschrijving :
#       Functie voor het verwijderen van de quotes aan begin en het einde van een string

sub removeQuotes
{
  my $string = shift;

  $string =~ s/^"//;
  $string =~ s/"$//;

  return $string;
}


# Functienaam : stringReplace
#
# Parameters (3x)
#	1) oldvalue, ofwel de string die gezocht wordt om te vervangen
#	2) newValue, de waarde waarmee de gevonden string vervangen word
#	3) de string waarin die een string bevat om te vervangen
#
# Omschrijving :
#	Functie om een string op te zoeken en te vervangen voor een andere waarde binnen een string
 
sub stringReplace
{
        my $oldValue = shift;
        my $newValue = shift; 
        my $string   = shift;

        $string =~ s/\Q$oldValue/$newValue/;

        return $string;
}

1;
