package nl.uvt.locator;
import nu.xom.*;

public class Diagnostic {
	int code;
	String message;
	String addInfo;
	
	public int getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public String getAddInfo() {
		return addInfo;
	}

	public Diagnostic(int code, String message) {
		super();
		this.code = code;
		this.message = message;
	}

	public Diagnostic(int code, String message, String addInfo) {
		super();
		this.code = code;
		this.message = message;
		this.addInfo = addInfo;
	}
	
	public String toString(){
		return "code= " + code + ", message='" + message + "', addInfo='" + addInfo + "'";
	}
	
	public Element toElement(){
		Element diag = new Element("diagnostic");
		diag.appendChild( makeNode( "code", Integer.toString( code ) ) );
		diag.appendChild( makeNode( "message", message ) );
		diag.appendChild( makeNode( "addInfo", addInfo ) );
		return diag;
		
	}
	
	private Element makeNode( String tag, String value ){
		Element node = new Element( tag );
		Text txt = new Text( value );
		node.appendChild( txt );
		return node;
	}
	
}
