package nl.uvt.locator;

import java.net.URLEncoder;
import java.util.List;

import nu.xom.*;

public class IllRequestor {
	Document getDocument( QueryData pQ ){
		Element root = new Element("records");
		Document doc = new Document( root );
		LocatorInfo li = generateLink( pQ );
		if ( li != null ){
			Node liNode = li.toRecordNode();
			root.appendChild( liNode );
		}
		//		Locator.logger.debug(doc.toXML());
		return doc;
	}

	class ILLinfo extends LocatorInfo {
		public boolean inRange( QueryData q ){ return true;};
		public boolean applyMethod( QueryData pQ ) { return true; };
		public Node toRecordNode(){
			Element record = new Element("record");
			record.appendChild( makeNode( "linkIssn", linkIssn ) );
			record.appendChild( makeNode( "linkTitle", linkTitle ) );
			record.appendChild( makeNode( "linkUrl", linkUrl) );
			record.appendChild( makeNode( "linkMethod", linkMethod ) );
			record.appendChild( makeNode( "rank", "10" ) );
			record.appendChild( makeNode( "generatedUrl", generatedUrl) );
			record.appendChild( makeNode( "publisher", linkPublisher ) );
			return record;
		}

	}

	private LocatorInfo generateLink(QueryData pQ ) {
		LocatorInfo li = new ILLinfo();
		li.linkMethod = "ILL";
		String db = "";
		String genre = pQ.genre;
		String loanForm = "";
		if ( genre.equals("article")){
			db = "2.3";
		}
		else {
			db = "2.4";
		}
		try {
		if ( mightWork( pQ ) ) {
			if  ( genre.equals("article") ||  genre.equals("bookitem") || genre.equals("proceeding" ) ){
				loanForm = "C";
			}
			else {
				loanForm = "L";
			}
			String ppn = pQ.ppn.replaceAll(" ", "");
			boolean doFree = false;
			if ( ppn.equals("") ){
				ppn = "FREE";
				doFree = true;
			}
			li.generatedUrl = "http://picarta.pica.nl/request/FORM/DB=" + db +  "/FORCETT=HTML/REQUEST?PPN=" + ppn
			+ "&loanform=" + loanForm + "&LNG=EN&RAPRF=surffederation";
			if ( doFree ){
				try {
					if ( !pQ.genre.equals("") ) 
						li.generatedUrl += "&genre=" + genre;
					if ( !pQ.isbn.equals("") ) 
						li.generatedUrl += "&isbn=" + pQ.isbn;
					if ( !pQ.issn.equals("") ) 
						li.generatedUrl += "&issn=" + pQ.issn;
					if ( pQ.thVolume > 0  ) 
						li.generatedUrl += "&volume=" + pQ.volume;
					if ( !pQ.issue.equals(""))
						li.generatedUrl += "&issue=" + pQ.issue;
					if ( !pQ.spage.equals(""))
						li.generatedUrl += "&spage=" + pQ.spage;
					if ( !pQ.pages.equals("") )
						li.generatedUrl += "&pages=" + pQ.pages;
					if ( !pQ.aulast.equals("") )
						li.generatedUrl += "&aulast=" + pQ.aulast;
					if ( !pQ.aufirst.equals("") )
						li.generatedUrl += "&aufirst=" + pQ.aufirst;
					if ( !pQ.auinit1.equals("") )
						li.generatedUrl += "&auinit1=" + pQ.auinit1;
					if ( !pQ.atitle.equals("") )
						li.generatedUrl += "&atitle=" + URLEncoder.encode( pQ.atitle, "ISO-8859-1" );
					if ( !pQ.title.equals("") )
						li.generatedUrl += "&title=" + URLEncoder.encode( pQ.title, "ISO-8859-1" );
					if ( !pQ.publisher.equals("") )
						li.generatedUrl += "&publisher=" + URLEncoder.encode( pQ.publisher, "ISO-8859-1" );
					if ( !pQ.placepub.equals("") )
						li.generatedUrl += "&placepub=" + URLEncoder.encode( pQ.placepub, "ISO-8859-1" );
					if ( pQ.date > 0 )
						li.generatedUrl += "&date=" + pQ.date;
				}
				catch( Exception e){
					Locator.logger.warn("Url generation failed on encoding problem." + e.getMessage() );
				}
				li.generatedUrl += "&dolocate=YES";
			}
			Locator.logger.debug("ILLlink:" + li.generatedUrl);
			return li;
		}
		else {
			Locator.logger.debug( "no record found in " + db );
			return null;
		}
		}
		catch( Exception e){
			Locator.logger.warn("checking db "  + db + " failed " + e.getMessage() );
			return null;
		}
	}
	
	private boolean mightWork( QueryData pQ ) throws LocatorException {
		TolkConnection tolk = new TolkConnection();
		List<LocatorInfo> locInfo = tolk.query( pQ );
		return locInfo != null;
	}

}
