package nl.uvt.locator;

import java.net.*;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import nu.xom.Document;
import nu.xom.Nodes;
import nl.uvt.commons.io.*;

public class LinkDbConnection {
	List<LocatorInfo> query( QueryData pQ ) throws LocatorException{
		List<LocatorInfo> linkInfo = null;
		if ( pQ.issn.length() > 0 ){
			linkInfo = queryLinkDbIssn( pQ );   
		}
		else if ( pQ.title.length() > 0 ){
			linkInfo = queryLinkDbTitle( pQ );   
		}
		return linkInfo;
	}
	

	private List<LocatorInfo> queryLinkDbIssn( QueryData pQ ) throws LocatorException {
		List<LocatorInfo> linkResult = null;
		nu.xom.Document result;
		String linkDbUrl = Locator.locatorConfig.getProperty("linkDbUri");
		String query = "";
		try {
			URL url = new URL( linkDbUrl );
			// try linkDb with issn
			Properties urlProps = new Properties( Locator.sruDefaultProps );
			query = URLEncoder.encode( pQ.issn, "ISO-8859-1" );
			urlProps.setProperty("query", "bath.issn="+query );
			result = Http.httpGetDocument( url, urlProps, Locator.httpConfig );
			if ( result != null ){
			Locator.logger.debug( "ISSN search returns:");
//			Locator.logger.debug( result.toXML() );
				int hits = Locator.extractHits( result );
				Locator.logger.debug("linkdb numOfRecords=" + hits );
				if ( hits > 0 ){
					linkResult = getLinkDbResults( result );
				}
			}
			else {
				Locator.logger.warn("No response from:" + linkDbUrl );
			}
		}
		catch (Exception e)  {
			throw new LocatorException( "LinkDb URL: '" + linkDbUrl + "' failed: " + e.getMessage());
		}
		return linkResult;
	}

	private  List<LocatorInfo> queryLinkDbTitle( QueryData pQ ) throws LocatorException {
		List<LocatorInfo> linkResult = null;
		nu.xom.Document result;
		String linkDbUrl = Locator.locatorConfig.getProperty("linkDbUri");
		try {
			URL url = new URL( linkDbUrl );
			// try linkDb with Title
			Properties props = new Properties( Locator.sruDefaultProps );
			String titleParts[] = pQ.title.split( ":", 2 );
			String mainTitle = pQ.title;
			if ( titleParts.length > 1 ){
				for( int i=0; i < titleParts.length; ++i )
					Locator.logger.debug( "part["+i+"]= '"+titleParts[i] +"'");
				mainTitle = titleParts[0];
			}
			// possible solution for %26 vs. & vs. &amp; problems
			// http://dbicluster.uvt.nl:4001/linkdb?version=1.1&operation=searchRetrieve&maximumRecords=10&query=dc.title%3D%22^Work%2C+employment+&amp;+society+^%22
			// gives 2 hits
			// http://dbicluster.uvt.nl:4001/linkdb?version=1.1&operation=searchRetrieve&maximumRecords=10&query=dc.title%3D%22^Work%2C+employment+&+society+^%22
			// also 2
			// http://dbicluster.uvt.nl:4001/linkdb?version=1.1&operation=searchRetrieve&maximumRecords=10&query=dc.title%3D%22^Work%2C+employment+%26+society+^%22
			// gives 0
			// http://dbicluster.uvt.nl:4001/linkdb?version=1.1&operation=searchRetrieve&maximumRecords=10&query=dc.title%3D%22^Work%2C+employment+and+society+^%22
			// gives 0
			// unfortunately, url encoding in httpGetDocument will replace '&' by %26 which is the right but inconvenient choice
			// it seems that zebra handled the following ok:
			// http://dbicluster.uvt.nl:4001/linkdb?version=1.1&operation=searchRetrieve&maximumRecords=10&query=dc.title%3D%22^Work%2C+employment+%26amp%3B+society+^%22
			mainTitle = mainTitle.replaceAll( " & ", " &amp; ");
			props.setProperty("query", "dc.title=\"^" + mainTitle + "^\"" );
			result = Http.httpGetDocument( url, props, Locator.httpConfig);
//			logger.debug( "linkDb Title search returns:");
//			logger.debug( result.toXML() );
			int hits = Locator.extractHits( result );
			Locator.logger.debug("linkdb numOfRecords=" + hits );
			if ( hits > 0 ){
				linkResult = getLinkDbResults( result );
			}
		}
		catch (Exception e) 
		{
			throw new LocatorException( "LinkDb URL:'" + linkDbUrl + "' failed: "+ e.getMessage());
		}
		return linkResult;
	}

	private List<LocatorInfo> getLinkDbResults( Document doc ){
		List<LocatorInfo> linkResult = null;
		Nodes records = doc.query("//srw:recordData/record|//srw:recordData/rec", Locator.sruContext);
		if ( records.size() > 0 ){
			linkResult = new LinkedList<LocatorInfo>();
			for ( int i=0; i < records.size(); ++i ){
				LinkDbInfo newInfo = new LinkDbInfo();
				if ( !newInfo.fill( records.get(i) ) )
					Locator.logger.warn("Errors in linkDb record: " + records.get(i).toXML() );
				Locator.logger.debug( newInfo.toString());
				linkResult.add( newInfo );
			}
		}
		else{
			Locator.logger.warn("no record fields found!");
			Locator.logger.warn(doc.toXML());
		}
		return linkResult;
	}


}
