package nl.uvt.locator;

import nu.xom.*;
import org.apache.log4j.*;

abstract public class LocatorInfo {
	String linkTitle;
	String linkIssn;
	String linkUrl;
	int rank;
	String linkMethod;
	String linkPublisher;
	String generatedUrl;

	protected Logger logger;

	LocatorInfo(){
		logger = Logger.getLogger(Locator.class);
		linkTitle = "";
		linkIssn = "";
		linkUrl = "";
		rank = 10;  // quite bad ranking
		generatedUrl = "";
		linkPublisher="";
		linkMethod = "";
	}
	
  abstract public boolean inRange( QueryData q );

  abstract public boolean applyMethod( QueryData pQ );
  abstract public Node toRecordNode();

	static Element makeNode( String tag, String value ){
		//
		//  Convenience routine to create a <tag>value</tag> Element 
		Element node = new Element( tag );
		Text txt = new Text( value );
		node.appendChild( txt );
		return node;
	}
	
	
}
