package nl.uvt.locator;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import nl.uvt.commons.io.*;

public class MerescoConnection {

	class MerescoCQL extends CQLfields{

		public void fill() {
			currentPrefix = "meresco.";
			String val = Locator.locatorConfig.getProperty( currentPrefix+"issnSelector", "mods.identifier=" );
			issnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"isbnSelector", "mods.identifier=" );
			isbnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"epnSelector", "mods.location.holdingSimple.copyInformation.note=" );
			epnSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"titleSelector", "mods.titleInfo.title=" );
			titleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"subTitleSelector", "mods.titleInfo.subTitle=" );
			subTitleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"fullTitleSelector",  "norm.fulljournaltitle exact" );
			fullTitleSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"locationSelector", "mods.location.holdingSimple.copyInformation.shelfLocator=" );
			locationSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"authorSelector", "norm.name.lastname=" );
			authorSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"dateSelector", "norm.date.year=" ); 
			dateSelector = val.replaceAll("\"","");
			val = Locator.locatorConfig.getProperty( currentPrefix+"repositorySelector", "meta.repository.repositoryGroupId exact opc-uvt-nl" );
			repositorySelector = val.replaceAll("\"","");
		}

	}
	
	MerescoCQL cqlData = new MerescoCQL();
	

	List<LocatorInfo> query( QueryData pQ ) throws LocatorException {
		cqlData.fill();
		List<LocatorInfo> meResult = null;
		nu.xom.Document result;
		String baseUrl = Locator.locatorConfig.getProperty("merescoUri");
		try {
			URL url = new URL( baseUrl );
			Properties props = new Properties( Locator.sruDefaultProps );
			props.setProperty("recordSchema","mods" );
			String query = CQLConnection.makeCQL( pQ, cqlData );
			if ( query.length() == 0 ){
				// fails when no useful data available
				return meResult;
			}
			query += " and " + cqlData.repositorySelector; 
			props.setProperty("query", query );
			result = Http.httpGetDocument( url, props, Locator.httpConfig );
			if ( result != null ){
				int hits = Locator.extractHits( result );
				Locator.logger.debug("meresco numOfRecords=" + hits );
				if ( hits > 0 ){
					//					Locator.logger.debug( "meresco doc:" + result.toXML());
					String sheetName = Locator.locatorConfig.getProperty("merescoSheet");
					meResult = HoldingInfo.getModsResults( result, pQ, sheetName );
				}
			}
			else {
				Locator.logger.warn("No response from:" + url );
			}
		}
		catch ( Exception e) {
			throw new LocatorException( "meresco URL: '" + baseUrl + "' failed"); 
		}
		return meResult;
	}

	
}
