#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use NOC::Net::SNMP; 
use NOC::Util::StringUtil;

if ($#ARGV != 6)
{
        print "Usage $0 <ip> <ifIndex 1> <ifIndex 2> <ifIndex 3> <ifIndex 4> <ifIndex 5> <ifIndex 6>\n";
        print "\t<ip>      = ip of router containing FWSM module\n";
        print "\t<ifIndex n> = index number of FWSM Gigabit interface\n";
        exit 0;
}

my $ip = $ARGV[0];               	# router ip
my @index = @ARGV[ 1 .. $#ARGV];        # array of interface indexes

my $snmp_community = "hkbu4kma";
my $snmp_options   = "-Oqv";

my $ifHCInOctets  = ".1.3.6.1.2.1.31.1.1.1.6";
my $ifHCOutOctets = ".1.3.6.1.2.1.31.1.1.1.10";

my $totalTrafficIn = 0;
my $totalTrafficOut = 0;

foreach my $index (@index)
{
#       print "$index\n";

	my $trafficOut = getInfoBySNMPv2($ip, $snmp_community, $ifHCOutOctets . "." . $index, $snmp_options);
        my $trafficIn = getInfoBySNMPv2($ip, $snmp_community, $ifHCInOctets . "." . $index, $snmp_options);

        $totalTrafficIn += $trafficIn;
        $totalTrafficOut += $trafficOut;

#       print "Traffic out on interface with index $index : $trafficOut\n";
#       print "Traffic in on interface with index $index : $trafficIn\n";
}

print "traffic_in:$totalTrafficIn traffic_out:$totalTrafficOut";
