#!/usr/bin/perl

# $Id: fwsm_cpu_usage.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/fwsm_cpu_usage.pl $

use warnings 'all';
use strict;
#use File::stat;
#use Time::localtime;
use Data::Dumper;

my $cpmCPUTotal5min = ".1.3.6.1.4.1.9.9.109.1.1.1.1.5.1";

my %fwsm_context =
(
	'admin'			=> '172.31.12.4',
	'alg-ms'		=> '137.56.250.4',
	'alg-nlb'		=> '137.56.253.4',
	'alg-ontw'		=> '137.56.254.4',
	'alg-srv-tst'		=> '137.56.252.4',
	'alg-voice-clnt'	=> '137.56.96.4',
        'alg-voice-srv' 	=> '137.56.192.4',
        'cd-giw'		=> '137.56.64.4',
        'dea-giw'		=> '137.56.75.4',
        'diensten-giw'		=> '137.56.76.4',
        'fdl-giw'		=> '137.56.128.4',
        'few-frontend'		=> '137.56.161.132',
        'few-giw'		=> '137.56.140.4',
        'few-rmasters'		=> '137.56.66.4',
        'frw-giw'		=> '137.56.132.4',
        'fsw-giw'		=> '137.56.136.4',
	'lis-giw-tst'		=> '137.56.252.132',
        'its-giw'		=> '137.56.176.4',
        'iva-giw'		=> '137.56.72.4',
        'fkt-giw'		=> '137.56.65.4',
        'tias-giw'		=> '137.56.68.4',
);

my %fwsm_context_cpu_usage = ();

for my $context_name ( keys %fwsm_context )
{
        my $context_ip = $fwsm_context{$context_name};
	#print "Context $context_name has ip $context_ip\n";

	open(SNMP, "snmpwalk -v2c -chkbu4kma -Oqv $context_ip $cpmCPUTotal5min |");
	while (<SNMP>)
	{
		$fwsm_context_cpu_usage{$context_name} = trim($_);
	}
	close(SNMP);
}

my $output = "";
for my $context_name ( keys %fwsm_context_cpu_usage )
{
	my $cpu_usage = $fwsm_context_cpu_usage{$context_name};
	$output .= "$context_name:$cpu_usage ";
}

print trim($output);

sub trim
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}
