use strict;
use warnings FATAL => 'all';

package NOC::Net::SNMP;

use NOC::Util::StringUtil;
use Exporter qw(import);

our @EXPORT = qw(getInfoBySNMPv2);
our @EXPORT_OK = @EXPORT;


# Functienaam : getInfoBySNMPv2
#
# Parameters : (4x)
#       1) ip adres van het device om uit te lezen
#       2) snmp community string
#       3) snmp oid
#       4) snmp options 
#
# Omschrijving :
#       Functie om data uit te lezen via snmp

sub getInfoBySNMPv2
{
	my ($ip, $community, $oid, $options) = @_;
	my $snmp_output = "";
	
	my $snmp_command = "snmpget -v2c -c$community $ip $oid $options |";
	open(SNMP, $snmp_command);
	while (<SNMP>)
	{
		$snmp_output .= $_;
	}
	close(SNMP);

	return trim($snmp_output);
}
