#!/usr/bin/perl

# $Id: fwsm_np_stats_hr.pl 7603 2013-04-11 09:28:27Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/fwsm_np_stats_hr.pl $

use strict;
use warnings FATAL => 'all';

use NOC::Net::SSH2; 
use NOC::Util::StringUtil;

if ($#ARGV != 0)
{
        print "Usage $0 <np>\n";
        print "\t<np> = number of Fast Path network processor (1 or 2)\n";
        exit 0;
}

my $np = $ARGV[0];
my $ip = "172.31.12.4";

my $ssh_output = getInfoBySSHCliCommand($ip, "cw2k", "DwvhnwUvTbca6Mfl", "enable\nDwvhnwUvTbca6Mfl\nchangeto context system\nterminal pager 0\nshow np $np stats | include pause|total packets|packets from|packets to|other blade|pkt drop\nquit\n");

my $output = "";

my @lines = split /\n/, $ssh_output;
foreach my $line (@lines)
{
	#print "$line\n";
        if ($line =~ m/^PKT_MNG:(.*)rcvd\s+:\s(\d+)/)
        {
                print "total_packets_received:$2 ";
        }
        if ($line =~ m/^PKT_MNG:(.*)sent\s+:\s(\d+)/)
        {
                print "total_packets_sent:$2 ";
        }
        if ($line =~ m/^PKT_MNG:(.*)dropped\s+:\s(\d+)/)
        {
                print "total_packets_dropped:$2 ";
        }


        if ($line =~ m/^PKT_MNG:(.*)to NP-3\s+:\s(\d+)/)
        {
                print "packets_to_np3:$2 ";
        }
        if ($line =~ m/^PKT_MNG:(.*)from NP-3\s+:\s(\d+)/)
        {
                print "packets_from_np3:$2 ";
        }

        if ($line =~ m/^PKT_MNG:(.*)to FWSM\s+:\s(\d+)/)
        {
                print "packets_to_fwsm:$2 ";
        }
        if ($line =~ m/^PKT_MNG:(.*)from FWSM\s+:\s(\d+)/)
        {
                print "packets_from_fwsm:$2 ";
        }


        if ($line =~ m/^PKT_MNG:(.*)to other blade\s+:\s(\d+)/)
        {
                print "packets_to_other_blade:$2 ";
        }
        if ($line =~ m/^PKT_MNG:(.*)from other blade\s+:\s(\d+)/)
        {
                print "packets_from_other_blade:$2 ";
        }


        if ($line =~ m/^PKT_MNG: pkt drop \(l2(.*)\s+:\s(\d+)/)
        {
                print "pkt_drop_l2:$2 ";
        }
        if ($line =~ m/^PKT_MNG: pkt drop \(l3(.*)\s+:\s(\d+)/)
        {
                print "pkt_drop_l3:$2 ";
        }
        if ($line =~ m/^PKT_MNG: pkt drop \(l4(.*)\s+:\s(\d+)/)
        {
                print "pkt_drop_l4:$2 ";
        }


        if ($line =~ m/^PF_MNG: pause(.*)\s+:\s(\d+)/)
        {
                print "pause_frames_sent:$2";
        }
}

print trim($output);
