#!/usr/bin/perl

# $Id: switch_temperatures.pl 7626 2013-04-12 11:55:29Z hurko $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/switch_temperatures.pl $

use strict;
use warnings FATAL => 'all';

# wellicht gaat de toch wat specifieke functie getMaxWalkValueBySNMPv2 naar de NOC::Net::SNMP library
# use NOC::Net::SNMP;
use NOC::Util::StringUtil;
use Data::Dumper;

if ($#ARGV < 0)
{
        print "Usage $0 <ip 1> <ip 2> ...\n";
        print "\t<ip n> = ip address of device\n";
        exit 0;
}

my %devices = ();

foreach my $arg (0 .. $#ARGV)
{
	$devices{$ARGV[$arg]} = 0;
}
my $snmp_community = "hkbu4kma";
my $snmp_options   = "-Oqv";

my $ciscoEnvMonTemperatureStatusValue = ".1.3.6.1.4.1.9.9.13.1.3.1.3";

foreach my $device (keys %devices)
{
	my @temps = sort { $b <=> $a } split(/\n/,getMaxWalkIntValueBySNMPv2($device, $snmp_community, $ciscoEnvMonTemperatureStatusValue, $snmp_options));
	my $maxTemp = $temps[0] ? $temps[0] : "NaN";
	$devices{$device} = $maxTemp;

 #       $output = $output . "$contr:$totalAPsPerController{$contr} ";
}

my $output = "";
foreach my $device (keys %devices)
{
	$output = $output . "$device:$devices{$device} ";
}

print trim($output);


# Functienaam : getMaxWalkIntValueBySNMPv2
#
# Parameters : (4x)
#       1) ip adres van het device om uit te lezen
#       2) snmp community string
#       3) snmp oid
#       4) snmp options
#
# Omschrijving :
#       Functie om max int value van een snmpwalk uit te lezen via snmp

sub getMaxWalkIntValueBySNMPv2
{
        my ($ip, $community, $oid, $options) = @_;
        my $snmp_output = "";

        my $snmp_command = "snmpwalk -v2c -c$community $ip $oid $options |";
        open(SNMP, $snmp_command);
        while (<SNMP>)
        {
                if ($_ =~ /^\d+$/)
                {
                        $snmp_output .= $_;
                }
        }
        close(SNMP);

        return trim($snmp_output);
}

