#!/usr/bin/perl

# $Id: wireless_traphic_received_bytes.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_traphic_received_bytes.pl $

use warnings 'all';
use strict;
use File::stat;
use Time::localtime;
use Data::Dumper;

my %totalTraphicPerControllerReceived = ();
my %totalTraphicPerControllerSent = ();

my %previousReceivedCountersPerController = ();
my %currentReceivedCountersPerController = ();

my $previousTime = 0;
if (-e "/home/hurko/test_scripts/wlc.received")
{
	$previousTime = stat("/home/hurko/test_scripts/wlc.received")->mtime;
	open(WLCDATA_READ, "/home/hurko/test_scripts/wlc.received");
	while (<WLCDATA_READ>)
	{
		my @line = split(/\|/);
		$previousReceivedCountersPerController{&trim($line[0])}->{&trim($line[1])} = &trim($line[2]);
	}
	close(WLCDATA_READ);
}

#print Dumper(%previousReceivedCountersPerController);

open(WLCDATA_WRITE, ">/home/hurko/test_scripts/wlc.received");

&getWLCTraphic("172.20.16.7", "wism-prim1");
&getWLCTraphic("172.20.16.9", "wism-prim2");
&getWLCTraphic("172.20.16.11", "wism-sec1");
&getWLCTraphic("172.20.16.13", "wism-sec2");

close(WLCDATA_WRITE);

my $currentTime = stat("/home/hurko/test_scripts/wlc.received")->mtime;

### CALCULATE BYTES RECEIVED PER ID FOREACH CONTROLLER ###

#print Dumper(%currentReceivedCountersPerController);
#print "-----------------";
#print Dumper(%previousReceivedCountersPerController);

foreach my $controller (keys %currentReceivedCountersPerController)
{
	if (exists($previousReceivedCountersPerController{$controller}))
	{
		#print "Calculating received bytes for controller : $controller\n";
		foreach my $entry (keys %{$currentReceivedCountersPerController{$controller}})
		{
			#print "ENTRY $entry -- $currentReceivedCountersPerController{$controller}->{$entry}\n";
		 	if (exists($previousReceivedCountersPerController{$controller}->{$entry}))
			{
				#print "   FOUND >$previousReceivedCountersPerController{$controller}->{$entry}<\n";
				my $currentReceived = $currentReceivedCountersPerController{$controller}->{$entry};
				my $previousReceived = $previousReceivedCountersPerController{$controller}->{$entry};

				#print "CR : $currentReceived\n";
				#print "PR : $previousReceived\n";
				if ($currentReceived > $previousReceived)
				{
				 	my $diff = $currentReceived - $previousReceived;	
					#print ">$diff<\n";
					#if (exists($totalTraphicPerControllerReceived{$controller}))
					#{
						$totalTraphicPerControllerReceived{$controller} = $totalTraphicPerControllerReceived{$controller} + $diff;
					#}	
					#else
					#{
					#	$totalTraphicPerControllerReceived{$controller} = $diff;
					#	print "### NONDEJU ###\n";
					#}
				}	
			} 	
		}
	}
}

my $diffTime = $currentTime - $previousTime;

my $output = "";
foreach my $contr (keys %totalTraphicPerControllerReceived)
{
	my $bytesReceivedGauge = $totalTraphicPerControllerReceived{$contr} / $diffTime;
	$output = $output . "$contr:$bytesReceivedGauge ";
	#print "XXX\t$contr -> $totalTraphicPerControllerReceived{$contr} -> $bytesReceivedGauge\n";
}

print &trim($output);

#my $bytesReceivedGauge = 0;
#foreach my $entry (keys %currentReceivedCountersPerController)
#{
	#if (exists($previousReceivedCountersPerController{$entry}))
	#{
	#	my $bytesReceived = $currentReceivedCountersPerController{$entry} - $previousReceivedCountersPerController{$entry};
	#	if ($bytesReceived > 0)
	#	{
	#		$bytesReceivedGauge = $bytesReceivedGauge + $bytesReceived;
	#	}
		#print "$currentReceivedCountersPerController{$entry} - $previousReceivedCountersPerController{$entry} = $bytesReceived\n";
#	}
#}
#print "Bytes : $bytesReceivedGauge\n";
#my $diffTime = $currentTime - $previousTime;
#print "$previousTime\n";
#print "$currentTime\n";
#print "Difference : $diffTime\n";

#$bytesReceivedGauge = $bytesReceivedGauge / $diffTime;
#print "Gauge : $bytesReceivedGauge\n";
 
#my @time = localtime();
#print Dumper(@time);

sub getWLCTraphic($_)
{
	#my $totalReceived = 0;
	#my $totalSent = 0;
	
	$totalTraphicPerControllerReceived{$_[0]} = 0;

	open(RECEIVED, "snmpwalk -v2c -cdpipvk $_[0] 1.3.6.1.4.1.14179.2.1.6.1.2 |");
	while (<RECEIVED>)
	{
		if (/\.(\S+).*?:\s+(\d+)/) 
		{
			#print ">$_[0].$1.$2<\n";
			$currentReceivedCountersPerController{$_[0]}->{$1} = $2;
			print WLCDATA_WRITE "$_[0]|$1|$2\n";
                        #$totalReceived = $totalReceived + $1;
                }
	}

	#open(SENT, "snmpwalk -v2c -cdpipvk $_[0] 1.3.6.1.4.1.14179.2.1.6.1.3 |");
        #while (<SENT>)
        #{
        #        if (/:\s+(\d+)/)
        #        {
        #                $totalSent = $totalSent + $1;
        #        }
        #}

	#$totalTraphicPerControllerReceived{$_[1]} = $totalReceived;
        #$totalTraphicPerControllerSent{$_[1]} = $totalSent;
}

#print Dumper(%totalTraphicPerControllerReceived);

# Perl trim function to remove whitespace and carriage return from the start and end of the string
sub trim($)
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

