#!/usr/bin/perl

# $Id: asa_sessions.pl 8161 2013-08-12 13:58:07Z hurko $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/script/asa_sessions.pl $

use strict;
use warnings FATAL => 'all';

use UvT::NOC::Net::SNMP; 

if ($#ARGV != 0)
{
        print "Usage $0 <ip>\n";
        print "\t<ip> = ip address of asa\n";
        exit 0;
}

my $ip = $ARGV[0];

# TODO : snmp community gegevens uit global config halen
my $snmp_community = "hkbu4kma";
my $snmp_options   = "-Oqv";

my $crasIPSecNumSessions = "1.3.6.1.4.1.9.9.392.1.3.26.0";
my $crasL2LNumSessions   = "1.3.6.1.4.1.9.9.392.1.3.29.0";
my $crasSVCNumSessions   = "1.3.6.1.4.1.9.9.392.1.3.35.0";

my $ipsec_sessions = getInfoBySNMPv2($ip, $snmp_community, $crasIPSecNumSessions, $snmp_options);
my $l2l_sessions   = getInfoBySNMPv2($ip, $snmp_community, $crasL2LNumSessions, $snmp_options);
my $ssl_sessions   = getInfoBySNMPv2($ip, $snmp_community, $crasSVCNumSessions, $snmp_options);

# print de cacti-output in het door cacti leesbare formaat :
# ipsec:23 ssl:104 l2l:3

print "ipsec:$ipsec_sessions ssl:$ssl_sessions l2l:$l2l_sessions";
