#!/usr/bin/perl

# $Id: wireless_traphic_received.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_traphic_received.pl $

use warnings 'all';
use strict;

my %totalTraphicPerControllerReceived = ();

&getWLCTraphic("172.20.16.7", "wism-prim1");
&getWLCTraphic("172.20.16.9", "wism-prim2");
&getWLCTraphic("172.20.16.11", "wism-sec1");
&getWLCTraphic("172.20.16.13", "wism-sec2");

sub getWLCTraphic($_)
{
	my $totalReceived = 0;

	open(RECEIVED, "snmpwalk -v2c -cdpipvk $_[0] 1.3.6.1.4.1.14179.2.1.6.1.2 |");
	while (<RECEIVED>)
	{
		if (/:\s+(\d+)/) 
		{
                        $totalReceived = $totalReceived + $1;
                }
	}

	$totalTraphicPerControllerReceived{$_[1]} = $totalReceived;
}

my $output = "";
foreach my $key (keys %totalTraphicPerControllerReceived)
{
	$output = $output . "$key:$totalTraphicPerControllerReceived{$key} ";
}
print &trim($output);

# Perl trim function to remove whitespace and carriage return from the start and end of the string
sub trim($)
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

