#!/usr/bin/perl

# $Id: wireless_associations.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_associations.pl $

my %totalAssociationsPerWLAN = ();

&getWLCAssociations("172.20.16.7");
&getWLCAssociations("172.20.16.9");
&getWLCAssociations("172.20.16.11");
&getWLCAssociations("172.20.16.13");
&getWLCAssociations("172.20.16.15");
&getWLCAssociations("172.20.16.17");
&getWLCAssociations("172.20.16.19");
&getWLCAssociations("172.20.16.21");

sub getWLCAssociations($_)
{
#       print "Getting data for : @_\n";
        my @ssid = ();
        my @associations = ();
        
        open(SSID, "snmpwalk -v2c -cdpipvk @_ 1.3.6.1.4.1.14179.2.1.1.1.2 |");
        while (<SSID>) {
                if (/:\s+"([^"]+)/) {
                        push(@ssid, $1);
                }
        }

        open(ACC, "snmpwalk -v2c -cdpipvk @_ 1.3.6.1.4.1.14179.2.1.1.1.38 |");
        while (<ACC>) {
                if (/:\s+(\d+)/) {
                        push(@associations, $1);
                }
        }
        close(ACC);
        
        for (0..$#ssid) {
#               print $ssid[$_], " : ", $associations[$_],$/;

                $totalAssociationsPerWLAN{$ssid[$_]} += $associations[$_];
        }

}

@permanent = ('UvT-Wireless','UvT-Welcome','UvT-SIP','eduroam', 'TN-Wireless');
foreach my $permanent_ssid (@permanent) {
        print "$permanent_ssid:$totalAssociationsPerWLAN{$permanent_ssid} ";
        delete($totalAssociationsPerWLAN{$permanent_ssid});
}

my $other = 0;
foreach my $key (keys %totalAssociationsPerWLAN) {
        $other += $totalAssociationsPerWLAN{$key};
}
print "Other:$other";
#print "=====================\n";
#foreach my $r (keys %totalAssociationsPerWLAN) {
#       print "$r : $totalAssociationsPerWLAN{$r}\n";
#}

