#!/usr/bin/perl

# $Id: $
# $URL: $

use strict;
use warnings FATAL => 'all';

use UvT::NOC::Net::SNMP; 

# leest het aantal access-accepts, access-rejects, access-requests, access-challenges en packets dropped uit
# van elke worker en sommeert deze als output

if ($#ARGV != 2)
{
    print "Usage $0 <host> <startport> <numworkers>...\n";
    print "\t<host> = radiator host address\n";
    print "\t<startport> = radiator host address\n";
    print "\t<numworkers> = number of workers\n";

    exit 0;
}

my $host      = $ARGV[0];
my $startport = $ARGV[1];
my $workers   = $ARGV[2];

# TODO : snmp community gegevens uit global config halen
my $snmp_community = "lN0CmtRSwS";
my $snmp_options   = "-Oqv";

my $radiusAuthServTotalAccessAccepts           = "1.3.6.1.2.1.67.1.1.1.1.8";
my $radiusAuthServTotalAccessRejects           = "1.3.6.1.2.1.67.1.1.1.1.9";
my $radiusAuthServTotalAccessRequests          = "1.3.6.1.2.1.67.1.1.1.1.5";
my $radiusAuthServTotalAccessChallenges        = "1.3.6.1.2.1.67.1.1.1.1.10";
my $radiusAuthServTotalPacketsDropped          = "1.3.6.1.2.1.67.1.1.1.1.13";

#my $radiusAuthServTotalBadAuthenticators       = "1.3.6.1.2.1.67.1.1.1.1.12";
#my $radiusAuthServTotalDupAccessRequests       = "1.3.6.1.2.1.67.1.1.1.1.7";
#my $radiusAuthServTotalMalformedAccessRequests = "1.3.6.1.2.1.67.1.1.1.1.11";
#my $radiusAuthServTotalInvalidRequests         = "1.3.6.1.2.1.67.1.1.1.1.6";
#my $radiusAuthServTotalUnknownTypes            = "1.3.6.1.2.1.67.1.1.1.1.14";


my $totalAccessAccepts    = 0;
my $totalAccessRejects    = 0;
my $totalAccessRequests   = 0;
my $totalAccessChallenges = 0;
my $totalPacketsDropped   = 0;

#my $totalBadAuthenticators       = 0;
#my $totalDupAccessRequests       = 0;
#my $totalMalformedAccessRequests = 0;
#my $totalInvalidRequests         = 0;
#my $totalUnknownTypes            = 0;


for ( my $port = $startport; $port <= ($startport + $workers - 1); $port++ )
{
	# snmpwalk -Os -c lN0CmtRSwS -v 1 radius1:9941 1.3.6.1.2.1.67.1.1.1.1 | head -14

	my $workerAccessAccepts = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalAccessAccepts, $snmp_options);
	# print "worker on $host:$port counts $workerAccessAccepts access accepts\n";
	my $workerAccessRejects = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalAccessRejects, $snmp_options);
	my $workerAccessRequests = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalAccessRequests, $snmp_options);
	my $workerAccessChallenges = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalAccessChallenges, $snmp_options);
	my $workerPacketsDropped = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalPacketsDropped, $snmp_options);

	# my $workerBadAuthenticators = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalBadAuthenticators, $snmp_options);
	# my $workerDupAccessRequests = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalDupAccessRequests, $snmp_options);
	# my $workerMalformedAccessRequests = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalMalformedAccessRequests, $snmp_options);
	# my $workerInvalidRequests = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalInvalidRequests, $snmp_options);
	# my $workerUnknownTypes = getInfoBySNMPv1($host . ":" . $port, $snmp_community, $radiusAuthServTotalUnknownTypes, $snmp_options);

 
	$totalAccessAccepts += $workerAccessAccepts;
	$totalAccessRejects += $workerAccessRejects;
	$totalAccessRequests += $workerAccessRequests;
	$totalAccessChallenges += $workerAccessChallenges;
	$totalPacketsDropped += $workerPacketsDropped;

	# $totalBadAuthenticators += $workerBadAuthenticators;
	# $totalDupAccessRequests += $workerDupAccessRequests;
	# $totalMalformedAccessRequests += $workerMalformedAccessRequests;
	# $totalInvalidRequests += $workerInvalidRequests;
	# $totalUnknownTypes += $workerUnknownTypes;
}

#my $total = $totalAccessAccepts + $totalAccessRejects + $totalAccessChallenges + $totalPacketsDropped + $totalBadAuthenticators + $totalDupAccessRequests + $totalMalformedAccessRequests + $totalInvalidRequests + $totalUnknownTypes;
#print "Total Access Accepts : $totalAccessAccepts\n";
#print "Total Access Rejects : $totalAccessRejects\n";
#print "Total Access Requests : $totalAccessRequests\n";
#print "Total Access Challenges : $totalAccessChallenges\n";
#print "Total Packets Dropped : $totalPacketsDropped\n";
#print "Total Bad Authenticators : $totalBadAuthenticators\n";
#print "Total Duplicate Access Requests : $totalDupAccessRequests\n";
#print "Total Malformed Requests : $totalMalformedAccessRequests\n";
#print "Total Invalid Requests : $totalInvalidRequests\n";
#print "Total Unknown Types : $totalUnknownTypes\n";

#print "Total : $total\n";
#print "Total Access Request : $totalAccessRequests\n";

print "totalAccessAccepts:$totalAccessAccepts totalAccessRejects:$totalAccessRejects totalAccessRequests:$totalAccessRequests totalAccessChallenges:$totalAccessChallenges totalPacketsDropped:$totalPacketsDropped\n";
