#!/usr/bin/perl

# $Id: wireless_client_traphic_sent.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_client_traphic_sent.pl $

use warnings 'all';
use strict;
use File::stat;
use Time::localtime;
use Data::Dumper;

my $temp_file = "/tmp/wlc.sent";

# het aantal bytes wat per controller is ontvangen
# dit wordt berekend door het verschil in counters per verbinding per controller op te tellen
my %totalTraphicPerControllerSent = ();

# hashes voor alles huidige rx/tx counters en de counters van de vorige run
my %currentSentCountersPerController = ();
my %previousSentCountersPerController = ();


### READ SNMP-DATA FROM PREVIOUS RUN BY TEMP FILE ###

# als er ooit een vorige run is geweest, dan de counters inlezen en in hash opslaan (subje van maken...)
my $previousTime = 0;
if (-e $temp_file)
{
        $previousTime = stat($temp_file)->mtime;
        open(WLCDATA_READ, $temp_file);
        while (<WLCDATA_READ>)
        {
                my @line = split(/\|/);
                $previousSentCountersPerController{&trim($line[0])}->{&trim($line[1])} = &trim($line[2]);
        }
        close(WLCDATA_READ);
}


### READ NEW SNMP-DATA FROM CONTROLLERS ###

# open handle naar de temp-file
open(WLCDATA_WRITE, ">$temp_file");

# lees nieuwe controller data uit en sla in temp-file op
# tevens wordt de nieuwe uitgelezen data ook in de current counters hash opgeslagen
&getWLCTraphic("172.20.16.7", "wism-prim1");
&getWLCTraphic("172.20.16.9", "wism-prim2");
&getWLCTraphic("172.20.16.11", "wism-sec1");
&getWLCTraphic("172.20.16.13", "wism-sec2");

# klaar met uitlezen, sluit file-handle
close(WLCDATA_WRITE);
my $currentTime = stat($temp_file)->mtime;


### CALCULATE BYTES SENT PER ID FOREACH CONTROLLER ###

foreach my $controller (keys %currentSentCountersPerController)
{
        if (exists($previousSentCountersPerController{$controller}))
        {
                foreach my $entry (keys %{$currentSentCountersPerController{$controller}})
                {
                        if (exists($previousSentCountersPerController{$controller}->{$entry}))
                        {
                                my $currentSent = $currentSentCountersPerController{$controller}->{$entry};
                                my $previousSent = $previousSentCountersPerController{$controller}->{$entry};

                                if ($currentSent > $previousSent)
                                {
                                        my $diff = $currentSent - $previousSent;
                                        $totalTraphicPerControllerSent{$controller} = $totalTraphicPerControllerSent{$controller} + $diff;
                                }
                        }
                }
        }
}

# bereken tijdspan tussen huidige en vorige uitlees actie (is nodig om de gauge bytes/sec te maken)
my $diffTime = $currentTime - $previousTime;

# loop door de hash heen om de output te genereren
# let op, aantal bytes sent per controller delen door tijdspanne !!!
my $output = "";
foreach my $contr (keys %totalTraphicPerControllerSent)
{
        my $bytesSentGauge = $totalTraphicPerControllerSent{$contr} / $diffTime;
        $output = $output . "$contr:$bytesSentGauge ";
}

print &trim($output);

sub getWLCTraphic($_)
{
        $totalTraphicPerControllerSent{$_[0]} = 0;
# dpipvk
        open(SENT, "snmpwalk -v2c -cdpipvk $_[0] 1.3.6.1.4.1.14179.2.1.6.1.3 |");
        while (<SENT>)
        {
                if (/\.(\S+).*?:\s+(\d+)/)
                {
                        $currentSentCountersPerController{$_[0]}->{$1} = $2;
                        print WLCDATA_WRITE "$_[0]|$1|$2\n";
                }
        }
}

# Perl trim function to remove whitespace and carriage return from the start and end of the string
sub trim($)
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

