#!/usr/bin/perl

# $Id: $
# $URL: $

use strict;
use warnings FATAL => 'all';

use UvT::NOC::Net::SNMP; 
use UvT::NOC::Util::StringUtil;

if ($#ARGV < 0)
{
    print "Usage $0 <ip 1> <ip 2> ...\n";
    print "\t<ip n> = ip address of wireless controller\n";
    exit 0;
}

my %controllers = ();

foreach my $arg (0 .. $#ARGV)
{
	$controllers{$ARGV[$arg]} = 0;
}

# TODO : snmp community gegevens uit global config halen
my $snmp_community = "hkbu4kma";
my $snmp_options   = "-Oqv";

my $bsnDot11EssSsid = ".1.3.6.1.4.1.14179.2.1.1.1.2";
my $bsnDot11EssNumberOfMobileStations = "1.3.6.1.4.1.14179.2.1.1.1.38";

my %totalAssociationsPerWLAN = ();

# Lees voor elke controller de ssid's uit met het bijbehorende aantal connecties en sla deze op in de hash $totalAssociationsPerWLAN met het ssid als key
foreach my $controller (keys %controllers)
{
	my @ssid = split(/\n/, walkInfoBySNMPv2($controller, $snmp_community, $bsnDot11EssSsid, $snmp_options));
	my @associations = split(/\n/, walkInfoBySNMPv2($controller, $snmp_community, $bsnDot11EssNumberOfMobileStations, $snmp_options));

	for (0..$#ssid)
	{
		$totalAssociationsPerWLAN{removeQuotes($ssid[$_])} += $associations[$_];
	}
}

# print de cacti-output in het door cacti leesbare formaat :
# UvT-Welcome:68 eduroam:949 Noc-Test:0 TN-Wireless:6 Faculty Club:3 Other:0

my $output = "";

# Alleen de 'permanente' ssid's krijgen een eigen lijntje op de grafiek
my @permanent = ('eduroam', 'Noc-Test', 'TN-Wireless', 'Faculty Club');
foreach my $permanent_ssid (@permanent)
{
    my $perm_cacti_ssid = $permanent_ssid;
    $perm_cacti_ssid =~ s/ /_/g;

    $output .= "$perm_cacti_ssid:$totalAssociationsPerWLAN{$permanent_ssid} ";
    delete($totalAssociationsPerWLAN{$permanent_ssid});
}

# de rest wordt bij elkaar opgeteld onder de noemer 'other'
my $other = 0;
foreach my $key (keys %totalAssociationsPerWLAN)
{
	$other += $totalAssociationsPerWLAN{$key};
}

$output .= "Other:$other";

print trim($output);

