#!/usr/bin/perl

# $Id: wireless_ap_assocations.pl 7604 2013-04-11 09:31:51Z joostvb $
# $URL: https://pong.uvt.nl/its-nettel/Netwerken/Procedures/noc-cacti-plugins/contrib/wireless_ap_assocations.pl $

my %totalAPsPerController = ();

&getWLCAssociations("172.20.16.7");
&getWLCAssociations("172.20.16.9");
&getWLCAssociations("172.20.16.11");
&getWLCAssociations("172.20.16.13");

sub getWLCAssociations()
{
	my $controller = shift;
        open(ACC, "snmpwalk -v2c -cdpipvk $controller 1.3.6.1.4.1.14179.2.2.1.1.3 | grep -v \"No Such Instance\" | wc |");
        while (<ACC>)
	{
                if (/^\s*(\d+)/)
		{
			$totalAPsPerController{$controller} = $1;
                }
        }
        close(ACC);
}

my $output = $output;

foreach my $contr (keys %totalAPsPerController)
{
	$output = $output . "$contr:$totalAPsPerController{$contr} ";
}

print &trim($output);

sub trim($)
{
  my $string = shift;
  $string =~ s/^\s+//;
  $string =~ s/\s+$//;
  return $string;
}

