# $Id: SQL.pm 40298 2013-09-25 10:00:59Z anton $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier/libpwdmodifier/lib/UvT/PwdModifier/SQL.pm $
#
# Er wordt door deze app geschreven naar adb123, die wordt eens in het uur ofzo gelezen
# in het GLW en de waarden worden dan overgenomen naar
# GLW-INGRES tabel: adb113 en de Oracle tabel adb113r. (r is replica).
# (Is inhoudelelijk hetzelfde als adb313 in de mibase).
# Initiëel worden de passwords ook door DEA in adb113r geplaatst.
#
# IDM
# Vanuit FIM wordt usernamentabel adb413usernaam bijgewerkt en die gaat naar Mibase en Ingres.
# Dit is adb113(r) zonder passwords.
# describe adb413usernaam;


# Schrijven en lezen moet voortaan alleen in adb123

# describe adb113r@lnkdea.kub.nl;
# USERNAAM       NOT NULL VARCHAR2(8)
# ANR            NOT NULL CHAR(6)
# CAT            CHAR(1)
# PWSERV         VARCHAR2(30) initëel cleartext password
# PW_SHA         VARCHAR2(150)
# PW_GPG         VARCHAR2(1500)
# PW_RCRYPT      VARCHAR2(200)
# USNUITG        datum uitgifte datepasswchanged			 VARCHAR2(8)
# USNVERV        datum vervallen					 VARCHAR2(8)
# USNSTAT        status, (moet 'a' zijn om naar ldap gestuurd te worden)
#
# describe adb123@lnkdea.kub.nl;
# Name			   Null?    Type
# ANR			   NOT NULL CHAR(6)
# USERNAME		   NOT NULL CHAR(8)
# PW_SHA_BEFORE		   NOT NULL VARCHAR2(150)
# PW_RCRYPT_BEFORE	   NOT NULL VARCHAR2(200)
# PW_SHA_AFTER		   NOT NULL VARCHAR2(150)
# PW_RCRYPT_AFTER	   NOT NULL VARCHAR2(200)
# CHANGE_TIME		   NOT NULL DATE
# CHANGED_BY		   VARCHAR2(40)
# TO_INGRES		   DATE

# describe adb131@lnkdea;
# ANR			   NOT NULL CHAR(6)
# EXTMAIL		   VARCHAR2(80)
# TOGLW			   CHAR(1)
# TOGLW_DATE	   DATE
# EPOCH_TIME	   NUMBER(10)
#
#
# describe adb132@lnkdea;
# ANR			   NOT NULL CHAR(6)
# SEQ			   NOT NULL NUMBER
# VRAAG			   NOT NULL VARCHAR2(256)
# ANTWOORD		   NOT NULL VARCHAR2(256)
#
#
# adb124@lnkdea.kub.nl (describe leidt tot de foutmelding: ERROR object KUB does not exist.
# ANR
# STATUS
# EPOCH_TIME
#
use strict;
use warnings FATAL => 'all';
package UvT::PwdModifier::SQL;
use Carp qw(cluck);
use Spiffy -Base;
use DBI;
use Data::Dumper;
field 'db';
field 'dsn', -init => 'die "no dsn configured\n"';
field 'user', -init => 'die "no db user configured\n"';
field 'pass' => '';

our $dbi_options = {
	AutoCommit => 0,
    PrintError => 0,
    RaiseError => 1,
    ShowErrorStatement => 1,
};

sub new {
	$self = super;
	my $db = DBI->connect($self->dsn, $self->user, $self->pass, $dbi_options);

	$self->{getAccount} = $db->prepare("SELECT anr, usernaam FROM adb413usernaam\@lnkpg WHERE anr = ? AND usnstat in ('A','E')");
	$self->{getUsername} = $db->prepare("SELECT usernaam FROM adb413usernaam\@lnkpg WHERE anr = ? AND usnstat in ('A','E')");

	$self->{getAnr} = $db->prepare("SELECT anr FROM adb413usernaam\@lnkpg WHERE usernaam = lower(?) AND usnstat in ('A','E')");
	$self->{previousPasswords} = $db->prepare("SELECT pw_rcrypt_after FROM adb123\@lnkdea.kub.nl WHERE anr = ? ORDER BY change_time");
	$self->{previousSHAPasswords} = $db->prepare("SELECT pw_sha_after FROM adb123\@lnkdea.kub.nl WHERE anr = ? ORDER BY change_time");
	$self->{initialPassword} = $db->prepare("SELECT pwserv FROM adb113r\@lnkdea.kub.nl WHERE anr = ?");

	$self->{setPwd} = $db->prepare(
		'INSERT INTO adb123@lnkdea.kub.nl (anr, username, pw_sha_before, pw_rcrypt_before, pw_sha_after, pw_rcrypt_after,
		changed_by, epoch_time, change_time) values (?,?,?,?,?,?,?,?,sysdate)');

	$self->{getQA} = $db->prepare('SELECT vraag, antwoord FROM adb132@lnkdea.kub.nl WHERE anr = ? ORDER BY seq');
	$self->{setQA} = $db->prepare('INSERT INTO adb132@lnkdea.kub.nl (anr, seq, vraag, antwoord) VALUES (?,?,?,?)');
	$self->{deleteQA} = $db->prepare('DELETE FROM adb132@lnkdea.kub.nl WHERE anr = ?');
	$self->{getMail} = $db->prepare('SELECT extmail, epoch_time FROM adb131@lnkdea.kub.nl WHERE anr = ?');
	$self->{setMail} = $db->prepare('INSERT INTO adb131@lnkdea.kub.nl (anr, extmail, epoch_time) VALUES (?,?,?)');
	$self->{deleteMail} = $db->prepare('DELETE FROM adb131@lnkdea.kub.nl WHERE anr = ?');
	$self->{setQAMTime} = $db->prepare('INSERT INTO adb131@lnkdea.kub.nl (anr, epochtime) VALUES (?,?)');
	$self->{getExpiredAccounts} = $db->prepare("SELECT a.anr, a.vrvg, a.famnaam, 
									                   b.epoch_time, b.account, b.mailname,
									                   d.orgnaam 
                                                FROM   deabeh.adb301 a,
									                   deabeh.adv001userandmailnaam b, 
                                                       deabeh.psb300 d
								                WHERE  a.anr = b.anr
                                                AND    a.anr = d.anr
										        AND    d.orgnaam LIKE 'LIS:%'
                                                AND    a.anr = '780251'
                                                AND    b.epoch_time < ?
                                                ORDER BY b.epoch_time" );

	$self->{getTotalNumberOfAccounts} = $db->prepare("SELECT COUNT (anr) FROM deabeh.adv001userandmailnaam");
	$self->{getExpirationStatus} = $db->prepare("SELECT anr, status, epoch_time FROM adb124\@lnkdea.kub.nl WHERE anr = ?");
	$self->{clearExpirationStatus} = $db->prepare('DELETE FROM adb124@lnkdea.kub.nl WHERE anr = ?');
	$self->{newExpirationStatus} = $db->prepare('INSERT into adb124@lnkdea.kub.nl (anr, epoch_time, status) VALUES (?,?,?)');
	$self->{changeExpirationStatus} = $db->prepare('UPDATE adb124@lnkdea.kub.nl SET epoch_time=?, status=? WHERE anr = ?');
	$self->{getLatestRcryptPassword} = $db->prepare('SELECT pw_rcrypt_after FROM adb123@lnkdea.kub.nl
			          WHERE epoch_time = (SELECT MAX (epoch_time) FROM adb123@lnkdea.kub.nl WHERE anr=?)');

	$self->db($db);
	return $self;
}


sub commit {
	$self->db->commit;
}

sub rollback {
	$self->db->rollback;
}

sub query {
        my $name = shift;
        my $q = $self->{$name};
		# pas op, soms is @_ leeg, daarom niet in de warn opnemen
		if ($name) { 
			warn "running query: $name:";
		} else {
			cluck "empty query!";
		}

		if ($_[0]) { 
			my $str = '';
			map { $str .= ", $_" if $_} @_;
#			warn "parameters: $str";
		} else {
			cluck "no parameters for query: $name!";
		}

        $q->execute(@_);
        return $q;
}


sub query_fetch {
	my $q = $self->query(@_);
	my $res; (@$res) = $q->fetch();
	$q->finish;
	return $res->[0]->[0];
}

sub query_fetchall {
	my $q = $self->query(@_);
	my $res = $q->fetchall_arrayref;
	$q->finish;
	return $res;
}

sub query_fetchall_hashref {
	my $field = shift;
	my $q = $self->query(@_);
	my $res = $q->fetchall_hashref($field);
	$q->finish;
	return $res;
}

sub query_fetchrow_hashref {
	my $q = $self->query(@_);
	my $res = $q->fetchrow_hashref();
	$q->finish;
	return $res;
}

sub query_do {
	my $q = $self->query(@_);
	$q->finish;
}

sub getQA {
	my $anr = shift;
	my $res = $self->query_fetchall('getQA', $anr);
	my $n = @$res;
	die "userError: Invalid number of questions ($n)"
		unless $n == 0 || $n == 2;
	return $res;
}

sub getQAStatus {
	my $anr = shift;
	my $res = $self->getQA($anr);
 	my $n = @$res;
	return $n?1:0;
}

sub setQA {
	my ($anr, $q1, $a1, $q2, $a2) = @_;
	$self->query_do('deleteQA', $anr);
	$self->query_do('setQA', $anr, 1, $q1, $a1) if ($q1 && $a1);
	$self->query_do('setQA', $anr, 2, $q2, $a2) if ($q2 && $a2);
}

sub getMail {
	my $anr = shift;
	my $res = $self->query_fetchall('getMail', $anr);
	my $n = @$res;
	die "userError: Invalid number of mail addresses ($n)"
		if $n > 1;
	my $mail = $res->[0]->[0];
	return $mail || 0;
}

sub getQAMModified {
	my $anr = shift;
	my $res = $self->query_fetchall('getMail', $anr);
	my $list = @$res[0];
	my $time = 0;
	if ($list) {
		$time = $list->[1] if $list->[1];
	}
	return $time;
}


sub clearExpirationStatus {
	my ($anr) = @_;
	$self->query_do('clearExpirationStatus', $anr);
}

sub newExpirationStatus {
	my ($anr, $time, $newstatus) = @_;
	$self->query_do('newExpirationStatus', @_);
}

sub changeExpirationStatus {
	my ($anr, $time, $newstatus) = @_;
	$self->query_do('changeExpirationStatus', $time, $newstatus, $anr);
}

sub setMail {
	my ($anr, $mail) = @_;
	$self->query_do('deleteMail', $anr);
	$self->query_do('setMail', $anr, $mail, time);
}

sub setPwd {
	$self->query_do('setPwd', @_);
}

sub previousSHAPasswords {
	my $anr = shift;
	my $res = $self->query_fetchall('previousSHAPasswords', $anr);
	return [map { my $r = $_->[0]; $r } @$res];
}

sub getCurrentSHAPassword {
	my $anr = shift;
	my $a = $self->previousSHAPasswords($anr);
	return $a->[-1];
}

sub getExpiredAccounts {
	my $timeDragline = shift;
	warn "timeDragline: $timeDragline";
	my $field = 'ANR';
	my $res = $self->query_fetchall_hashref($field, 'getExpiredAccounts', $timeDragline);
	warn "Res:";
	warn Dumper($res);
	return $res;
}

sub getExpirationStatus {
	my $anr = shift;
	my $res = $self->query_fetchall('getExpirationStatus', $anr);
 	return  $res;
}

sub getExpirationStatusHash {
	my $anr = shift;
	my $res = $self->query_fetchrow_hashref('getExpirationStatus', $anr);
 	return  $res;
}

sub getTotalNumberOfAccounts {
	my $res = $self->query_fetch('getTotalNumberOfAccounts');
	return $res;
}

sub previousPasswords {
	my $anr = shift;
	my $res = $self->query_fetchall('previousPasswords', $anr);
 	return [map { my $r = $_->[0]; $r =~ s/^\{rcrypt\}//; $r } @$res];
}

sub getInitialPassword {
	my $anr = shift;
	my $res = $self->query_fetchall('initialPassword', $anr);
	my $n = @$res;
	return $res->[0][0];
}


#sub getLatestRcrtypPassword {
#	my $anr = shift;
#	my $res = $self->query_fetchall('getLatestRcrtypPassword', $anr);
# 	return [map { my $r = $_->[0]; $r =~ s/^\{rcrypt\}//; $r } @$res];
#
#}

sub getCurrentRcryptPassword {
	my $anr = shift;
	my $a = $self->previousPasswords($anr);
	return $a->[-1];
}

sub getUsername {
	my $anr = shift;
	my $res = $self->query_fetchall('getUsername', $anr);
	my $n = @$res;

	if ($n == 1){
		return $res->[0][0];
	} else {
		die "userError: Invalid number of uids for anr:$anr". Dumper($res)
			if $n > 1;

		warn "userError: No (active) uid found for anr '$anr'";
		return undef;
	}
}



sub getAnr {
	my $uid = shift;
	my $res = $self->query_fetchall('getAnr', $uid);
	my $n = @$res;

	if ($n == 1){
		return $res->[0][0];
	} else {
		die "userError: Invalid number of anrs for uid:$uid". Dumper($res)
			if $n > 1;

		warn "userError: No anr found for uid '$uid'";
		return undef;
	}
}
