<?php

require_once 'aselect/client.php';

function check_credentials() {
	$state = SimpleSAML_Auth_State::loadState($_REQUEST['ssp_state'], 'aselectagent:login');
	$creds = aselect_verify_credentials_full($_REQUEST['rid'], $_REQUEST['aselect_credentials']);
	if(is_null($creds))
		SimpleSAML_Auth_State::throwException($state, new SimpleSAML_Error_Exception("Expired/invalid A-Select credentials"));
	if(array_key_exists('attributes', $creds)) {
		$state['Attributes'] = $creds['attributes'];
	} else {
		$res = $creds['res'];
		$state['Attributes'] = array('uid' => array($res['uid']), 'organization' => array($res['organization']));
	}
	SimpleSAML_Auth_Source::completeAuth($state);
	SimpleSAML_Auth_State::throwException($state, new SimpleSAML_Error_Exception("Internal error in A-Select component"));
}

check_credentials();
