<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml" encoding="UTF-8"/>

	<xsl:template match="/">
		<mailtje>
			<xsl:apply-templates select="persoon"/>
		</mailtje>
	</xsl:template>

    <xsl:template match="persoon">
		<nederlands>
			<kop>accountinformatie</kop>
			<par>Beste student,</par>
			<xsl:choose>
				<xsl:when test="type='herinschrijver'">
					<par>Je ontvangt deze mail omdat je weer recht hebt op gebruik van de online faciliteiten van Tilburg University. Hieronder tref je jouw accountgegevens aan.</par>
				</xsl:when>
				<xsl:otherwise>
					<par>In deze mail tref je de gegevens aan van je Tilburg University account, waarmee je gebruik kan maken van onze online faciliteiten.</par>
				</xsl:otherwise>
			</xsl:choose>
		</nederlands>

		<engels>
			<kop>account information</kop>
			<par>Dear student,</par>
			<xsl:choose>
				<xsl:when test="type='herinschrijver'">
					<par>You recieve this mail because you are entitled again to use the online facilities of Tilburg University. Please find below the information for your account.</par>
				</xsl:when>
				<xsl:otherwise>
					<par>Please find below the information for your Tilburg University account. You will need this account to gain access to our online facilities.</par>
				</xsl:otherwise>
			</xsl:choose>
		</engels>

		<allebei>
			<par><table>
				<tr><th>User name:</th><td><xsl:value-of select="uid"/></td></tr>
				<tr><th>Mail address:</th><td><xsl:value-of select="mail"/></td></tr>
				<tr><th>Student number:</th><td><xsl:value-of select="emplid"/></td></tr>
				<tr><th>ANR (University card):</th><td><xsl:value-of select="anr"/></td></tr>
			</table></par>
		</allebei>

		<nederlands>
			<par><em>Door middel van het instellen van je password activeer je jouw account. Raadpleeg voordat je dit doet eerst de <a href="http://www.tilburguniversity.edu/upload/a4481b4c-b2f8-4a6f-bd3f-4607882aa239_gedragscodeict.pdf">voorwaarden voor gebruik</a> in de 'Gedragscode e-mail-, internet- en telefoonfaciliteiten'. Met het activeren van je account stem je in met de gedragscode.</em></par>
			<par>Klik op onderstaande link om je eigen password aan te maken. Je ontvangt dan binnen 10 minuten een mail van de LIS Service Desk. Deze mail bevat een beveiligde link waarmee je je password kan instellen.</par>
			<par>Ga naar de <a href="https://cgi.uvt.nl/cgi-bin/gatekeeper/mailchallenge?language=nl&amp;uid={uid}">Selfservice universiteitsaccount</a>.</par>
			<par>Als je geen mail krijgt:<ul><li>Controleer je junk- of spammailfolder.</li><li>Voeg lis-servicedesk@uvt.nl toe aan je lijst met mailcontacten of whitelist.</li><li>Gebruik de link opnieuw.</li><li>Vraag ondersteuning bij de <a href="http://www.tilburguniversity.edu/nl/studenten/it/lis-sd/">Service Desk</a> van Library &amp; IT Services.</li></ul></par>
			<par>Je Tilburg University mailbox kan je raadplegen via <a href="www.tilburguniversity.edu/cloud/mail">www.tilburguniversity.edu/cloud/mail</a>.</par>
			<par>Houd er rekening mee dat je username en password strikt persoonlijk zijn en onder geen beding aan anderen ter beschikking gesteld mogen worden.</par>
			<!-- alleen voor niet-exchangestudenten: -->
			<xsl:if test="type!='exchange'">
				<par>Let op: je account wordt automatisch geblokkeerd als je inschrijving niet tijdig wordt afgerond. Informatie over het verloop van de inschrijfprocedure is te vinden op de <a href="https://tiu.nu/Inschrijving">Inschrijvingswebsite</a>.</par>
			</xsl:if>
			<par>Met vriendelijke groet,</par>
			<par>Student Administration<br/>Tilburg University</par>
		</nederlands>

		<engels>
			<par><em>By setting the password you will activate your account. Before you put this into effect, please consult the <a href="http://www.tilburguniversity.edu/upload/bf821b8a-326b-4fb7-ab14-1c8b50382d6b_email-telephone.pdf">conditions for use</a> in the 'Code of Conduct for the Use of E-mail, Internet and Telephone Facilities'. By activating your account you consent to this Code of Conduct.</em></par>
			<par>After clicking the link below you will receive an email within 10 minutes from the LIS Service Desk which contains a secured link that enables you to set your own password.</par>
			<par>Go to the <a href="https://cgi.uvt.nl/cgi-bin/gatekeeper/mailchallenge?uid={uid}">Self-service university account</a>.</par>
			<par>If you do not receive this mail:<ul><li>Check your junk or spam mail folder.</li><li>Add lis-servicedesk@uvt.nl to your mail contacts list or whitelist.</li><li>Try the link again.</li><li>Ask the <a href="http://www.tilburguniversity.edu/students/it/lis-sd/">Service Desk</a> of Library &amp; IT Services for support.</li></ul></par>
			<par>To access your Tilburg University mailbox, please visit <a href="www.tilburguniversity.edu/cloud/mail">www.tilburguniversity.edu/cloud/mail</a>.</par>
			<par>Keep in mind that your user name and password are strictly personal and under no circumstances should be given to others.</par>
			<xsl:if test="type!='exchange'">
				<par>Please notice that your account will be blocked if your registration is not completed in time. More information about the registration procedure can be found on the <a href="https://tiu.nu/registration">Registration website</a>.</par>
			</xsl:if>
			<par>Yours sincerely,</par>
			<par>Student Administration<br/>Tilburg University</par>
		</engels>
	</xsl:template>
</xsl:transform>
