<xsl:transform
	version="1.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:html="http://www.w3.org/1999/xhtml"
	exclude-result-prefixes="html">

	<!-- $Id: html.xsl 39318 2013-05-02 13:49:32Z wsl $ -->
	<!-- $URL: https://svn.uvt.nl/its-id/trunk/sources/uvt-email-template/share/html.xsl $ -->

	<xsl:output method="html" media-type="text/html" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>

	<xsl:template match="mailtje">
		<html style="background: #ddd">
			<body style="background: #ddd" link="#008ec6" vlink="#008ec6" alink="#000">
				<div align="center">
					<table style="background: #fff; width: 435pt; border-collapse: collapse; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; -moz-box-shadow: 3px 3px 12px #aaa; -webkit-box-shadow: 3px 3px 12px #aaa; -khtml-box-shadow: 3px 3px 12px #aaa; -o-box-shadow: 3px 3px 12px #aaa; box-shadow: 3px 3px 12px #aaa">
						<thead>
							<tr>
								<td align="left" style="padding: 14pt 14pt 7pt 14pt; width: 50%">
									<img src="logo-smaller.png" alt="TiU logo"/>
								</td>
								<td align="right" style="padding: 14pt 20pt 7pt 14pt; width: 50%">
									<img src="slogan-smaller.png" alt="TiU slogan"/>
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<hr noshade="noshade" size="1" style="color: #c93; background-color: #c93; height: 1px; border: none"/>
								</td>
							</tr>
						</thead>
						<tbody>
							<tr>
								<th scope="col" lang="nl" align="left" style="padding: 14pt 14pt 14pt 14pt">
									<h1 style="text-align: bottom; font-family: Arial, sans-serif; font-size: 21pt; font-weight: normal; color: #cc9933">
										<xsl:apply-templates select="nederlands/kop/node()" mode="html"/>
									</h1>
								</th>
								<th scope="col" lang="en" align="left" style="padding: 14pt 14pt 14pt 14pt">
									<h1 style="text-align: bottom; font-family: Arial, sans-serif; font-size: 21pt; font-weight: normal; color: #cc9933">
										<xsl:apply-templates select="engels/kop/node()" mode="html"/>
									</h1>
								</th>
							</tr>
							<xsl:apply-templates select="nederlands|allebei"/>

						</tbody>
						<tfoot>
							<tr>
								<td colspan="2">&#160;</td>
							</tr>
							<tr>
								<td colspan="2" style="padding: 0pt 0pt 0pt 0pt">
									<hr noshade="noshade" size="1" style="color: #c93; background-color: #c93; height: 1px; border: none"/>
								</td>
							</tr>
							<tr>
								<td colspan="2">
									<p style="font-family: Arial, sans-serif; font-size: 80%; color: #c3bcb2; text-align: center; margin: 0pt 0pt 0pt 0pt">Tilburg University &#8211; Warandelaan 2 &#8211; 5037 AB Tilburg</p>
									<p style="font-family: Arial, sans-serif; font-size: 80%; color: #c3bcb2; text-align: center; margin: 0pt 0pt 10pt 0pt"><a style="color: #c3bcb2" href="http://www.tilburguniversity.edu/" target="_blank">www.tilburguniversity.edu</a> &#8211; <a style="color: #c3bcb2" href="http://www.tilburguniversity.edu/nl/contact/" target="_blank">routebeschrijving</a> | <a style="color: #c3bcb2" href="http://www.tilburguniversity.edu/contact/" target="_blank">route description</a></p>
								</td>
							</tr>
						</tfoot>
					</table>
				</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="nederlands">
		<xsl:variable name="nlindex" select="count(preceding-sibling::nederlands) + 1"/>
		<xsl:for-each select="par">
			<tr>
				<td lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">
					<xsl:apply-templates select="node()" mode="html"/>
				</td>
				<xsl:variable name="parindex" select="count(preceding-sibling::par) + 1"/>
				<td lang="en" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">
					<xsl:apply-templates select="../../engels[position() = $nlindex]/par[position() = $parindex]/node()" mode="html"/>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="allebei">
		<xsl:for-each select="par">
			<tr align="center">
				<td colspan="2" lang="nl" style="padding: 0pt 14pt 14pt 14pt; font-family: Arial, sans-serif; color: #000; vertical-align: top">
					<xsl:apply-templates select="node()" mode="html"/>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="html/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="head/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="body/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="div/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="table/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="tr/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="ul/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="ol/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="dl/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="form/text()[normalize-space()='']" mode="html"/>
	<xsl:template match="select/text()[normalize-space()='']" mode="html"/>

	<xsl:template match="text()|a/@href|img/@src|img/@alt" mode="html">
		<xsl:copy/>
	</xsl:template>

	<xsl:template match="a" mode="html">
		<a style="color: #008ec6">
			<xsl:apply-templates select="@*|node()" mode="html"/>
		</a>
	</xsl:template>

	<xsl:template match="img" mode="html">
		<img border="0">
			<xsl:apply-templates select="@*|node()" mode="html"/>
		</img>
	</xsl:template>

	<xsl:template match="table" mode="html">
		<table border="1" bordercolor="#c3bcb2" align="center" cellspacing="0" cellpadding="0" style="border: 1px solid #c3bcb2; border-collapse: collapse">
			<xsl:apply-templates select="tr" mode="html"/>
		</table>
	</xsl:template>

	<xsl:template match="tr" mode="html">
		<tr align="left" valign="top">
			<xsl:apply-templates select="th|td" mode="html"/>
		</tr>
	</xsl:template>

	<xsl:template match="th|td" mode="html">
		<xsl:element name="{local-name()}">
			<xsl:attribute name="align">left</xsl:attribute>
			<xsl:attribute name="valign">top</xsl:attribute>
			<xsl:attribute name="style">text-align: left; font-family: Arial, sans-serif; font-size: 9pt; line-height: 14pt; padding: 1pt 10pt; margin: 0</xsl:attribute>
			<xsl:apply-templates select="@*|node()" mode="html"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ul|ol" mode="html">
		<xsl:element name="{local-name()}">
			<xsl:attribute name="style">margin-before: 0pt; -moz-margin-before: 0pt; -webkit-margin-before: 0pt; -khtml-margin-before: 0pt; -o-margin-before: 0pt; margin-after: 0pt; -moz-margin-after: 0pt; -webkit-margin-after: 0pt; -khtml-margin-after: 0pt; -o-margin-after: 0pt</xsl:attribute>
			<xsl:apply-templates select="@*|node()" mode="html"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="li" mode="html">
		<li style="margin-left: 0pt">
			<xsl:apply-templates select="@*|node()" mode="html"/>
		</li>
	</xsl:template>

	<xsl:template match="strong|em|br" mode="html">
		<xsl:element name="{local-name()}">
			<xsl:apply-templates select="@*|node()" mode="html"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="@*" mode="html">
		<xsl:message terminate="yes">Unsupported HTML attribute '<xsl:value-of select="name()"/>' on element '<xsl:value-of select="local-name(..)"/>'</xsl:message>
	</xsl:template>

	<xsl:template match="*" mode="html">
		<xsl:message terminate="yes">Unsupported HTML element '<xsl:value-of select="name()"/>'</xsl:message>
	</xsl:template>

	<xsl:template match="comment()" mode="html"/>

	<xsl:template match="processing-instruction()" mode="html">
		<xsl:message terminate="yes">HTML processing instructions not supported</xsl:message>
	</xsl:template>

	<xsl:template match="node()" mode="html" priority="-1">
		<xsl:message terminate="yes">Unknown node type encountered</xsl:message>
	</xsl:template>
</xsl:transform>
