# $Id: WMSSQL.pm 38838 2013-02-21 13:24:40Z anton $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/wms-conduit/lib/WMSSQL.pm $
#
use strict;
use warnings FATAL => 'all';
our $VERSION = "1.3";

package WMSSQL;

use Spiffy -Base;

use DBI;
use Data::Dumper;

field 'db';
field 'dsn', -init => 'die "no dsn configured\n"';
field 'user', -init => 'die "no db user configured\n"';
field 'pass' => '';
field 'maxSQLConnectionRetries', -init => 'die "no maxSQLConnectionRetries configured\n"'; 

our $dbi_options = {
	AutoCommit => 0,
    PrintError => 0,
    RaiseError => 1,
    ShowErrorStatement => 1,
	mysql_enable_utf8 =>1,
};

sub new {
	$self = super;
	my $maxRetries = $self->maxSQLConnectionRetries;
	my $attempt = 0;
	my $db;
#	DBI->trace(4);
	while (!$db && $attempt++ < $maxRetries) {
		my $user = $self->user;
		my $dsn = $self->dsn; 
		$db = eval {
			DBI->connect($dsn, $user, $self->pass, $dbi_options);
		};
		warn "errstr: $DBI::errstr" if $DBI::errstr;
		my $error = "Unknown error";
		$error = $DBI::errstr if $DBI::errstr;
		warn "$error, (dns: $dsn, user: $user) attempt: ", $attempt unless $db;
	}
	die "Out of connection attempts($maxRetries). Aborted" unless $db; 

	$db->{'mysql_enable_utf8'} = 1;
	$self->db($db);
	return $self;
}

sub commit {
	$self->db->commit;
}

sub rollback {
	$self->db->rollback;
}

sub getAllGuests {
	my $activePeriod = shift;
	my $db = $self->{db};
	my $res = $db->selectall_arrayref("SELECT achternaam, anr, email, password, roepnaam, tussenvoegsel, userid, voorletters, to_char(geboortedatum, 'yyyy-mm-dd') \"GEBOORTEDATUM\", geslacht, to_char(einddatum, 'yyyy-mm-dd') \"EINDDATUM\", profiel FROM gast WHERE rol = 3 AND einddatum >= SYSDATE-? ORDER BY anr ", {Slice => {}}, $activePeriod);
	return $res;
}

sub getAllUids {
	my $db = $self->{db};
	$db->selectall_arrayref("SELECT anr, usernaam FROM adb413usernaam WHERE usnstat in ('A','E') ORDER BY anr", {Slice => {}});
}

sub setGuestUid {
	my $guest = shift;
	my $db = $self->{db};
	warn "updating guest uid: for $guest->{ANR}\n";
	my $handle = $db->prepare('UPDATE gast SET userid = ? WHERE anr=?');
 	$handle->execute($guest->{USERID}, $guest->{ANR});
}

sub getRelatieCode {
	my $guest = shift; 
	my $db = $self->{db};
	my $statement = "SELECT code, anr FROM adb406relatie WHERE anr =?";
	my $res  = $db->selectall_arrayref($statement, {Slice=>{}}, $guest->{ANR});
	if (@$res[0]) {
		return @$res[0]->{CODE};
	} else {
#		warn "NO relatiecode for: $guest->{ANR}\n";
		return -1;
	}
}

sub getAllUsers {
	my $db = $self->{db};
	$db->selectall_arrayref("SELECT anr, famnaam, vrvg, vrlet, gebdt, gesl FROM adb401naamadreswoonplaats ORDER BY anr", {Slice => {}});
}

sub updateUser {
	my $guest = shift;
	my $db = $self->{db};
	warn "Updating user: $guest->{ANR}\n";
	my $handle = $db->prepare('UPDATE adb401naamadreswoonplaats SET famnaam=?, vrvg=?, vrlet=?, gebdt=?, gesl=? WHERE ANR=?');
	$handle->execute(
		$guest->{ACHTERNAAM},
		$guest->{TUSSENVOEGSEL},
		$guest->{VOORLETTERS},             
		$guest->{GEBOORTEDATUM_CHAR}, 
		$guest->{GESLACHT},
		$guest->{ANR} );
}


sub addUser {
	my $guest = shift;
	my $db = $self->{db};
	warn "Adding user: $guest->{ANR}, $guest->{ACHTERNAAM}\n";
	my $handle = $db->prepare('INSERT INTO adb401naamadreswoonplaats (anr, famnaam, vrvg, vrlet, gebdt, gesl) VALUES (?,?,?,?,?,?)');
	$handle->execute(
		$guest->{ANR}, 
		$guest->{ACHTERNAAM},
		$guest->{TUSSENVOEGSEL},
		$guest->{VOORLETTERS},             
		$guest->{GEBOORTEDATUM_CHAR}, 
		$guest->{GESLACHT});
}

sub addUid {
	my $guest = shift;
	my $db = $self->{db};
	warn "Adding account: $guest->{ANR}, $guest->{USERID}\n"; 
	my $handle = $db->prepare('INSERT INTO adb413usernaam (usernaam, anr, cat, usnuitg, usnverv, usnstat) VALUES (?,?,?,?,?,?)');
	die "prepare failed" unless $handle;

	my ($d,$m,$y) = (localtime)[3,4,5];
	my $date = sprintf '%04d%02d%02d', $y + 1900, $m + 1, $d;
	#                     usernaam        anr   cat  usnuitg, usnverv usnstat
	$handle->execute($guest->{USERID}, $guest->{ANR}, 'S', $date,   undef,  'A');
}

sub deleteAccount {
	my $anr = shift;
	my $db = $self->{db};
	warn "Deleting account: $anr\n";
	my $handle = $db->prepare('DELETE FROM adb413usernaam WHERE anr = ?');
	$handle->execute($anr);
	$handle = $db->prepare('DELETE FROM adb401naamadreswoonplaats WHERE anr = ?');
	$handle->execute($anr);
}



=pod

=encoding utf8

=head1 NAME

WMSSQL - Push stuff to WMS
