use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Handler;

use Clarity -self;

our @EXPORT_BASE = qw(resource);

sub resource(&) {
	my $name = shift;
	my $package = caller;
	my $code = "package $package; field \$name => sub { super }";
	my $err = do { local $@; eval $code; $@ };
	confess $err if $err;
}

use Xyzzy::Fail;

field cfg;

field handler => sub { new Xyzzy::Fail(cfg => shift->cfg, code => 501) };

sub handle {
	$self->handler->handle(@_);
}

sub DESTROY {} # don't try to autoload this

sub AUTOLOAD {
	my $off = rindex(our $AUTOLOAD, '::');
	confess "no package name in '$AUTOLOAD'"
		if $off == -1;
	my $sub = substr($AUTOLOAD, $off + 2);
	my $cfg = $self->cfg;
	my $code = "sub $sub { my \$self = shift; return \$self->cfg->$sub(\@_) }";
	my $err = do { local $@; eval $code; $@ };
	confess $err if $err;
	return $cfg->$sub(@_);
}
