#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Xyzzy::Crypto') or BAIL_OUT('need Xyzzy::Crypto to run') }
BEGIN { use_ok('Xyzzy::Crypto::Config') or BAIL_OUT('need Xyzzy::Crypto::Config to run') }

my $cfg = new_ok('Xyzzy::Crypto::Config') or BAIL_OUT('need a Xyzzy::Crypto::Config object to run');

$cfg->set_cryptosecret('hunter2');

my $crypto = new_ok('Xyzzy::Crypto', [cfg => $cfg]) or BAIL_OUT('need a Xyzzy::Crypto object to run');

my $token = $crypto->create_token('test', 'foo', 'bar');

ok($token, "manages to create a token");

my ($time, $salt, @foobar) = $crypto->check_token('test', $token, 3);



done_testing();
