#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Xyzzy::Directory') or BAIL_OUT('need Xyzzy::Directory to run') }

new_ok('Xyzzy::Directory') or BAIL_OUT('need a Xyzzy::Directory object to run');

foreach my $t (
	['', []],
	['//', []],
	['/foo', ['foo']],
	['//foo', ['foo']],
	['//foo/', ['foo']],
	['//foo//', ['foo']],
	['/foo/bar', ['foo', 'bar']],
	['/foo/bar/', ['foo', 'bar']],
	['/foo//bar/', ['foo', 'bar']],
	['/foo//bar//', ['foo', 'bar']],
) {
	my ($in, $out) = @$t;
	is_deeply(Xyzzy::Directory::Request::split_path($in), $out, "split_path");
}

done_testing();
