#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Xyzzy::Request') or BAIL_OUT('need Xyzzy::Request to run') }
BEGIN { use_ok('Xyzzy::Request::Root') or BAIL_OUT('need Xyzzy::Request::Root to run') }
BEGIN { use_ok('Xyzzy::Document') or BAIL_OUT('need Xyzzy::Document to run') }

new_ok('Xyzzy::Document') or BAIL_OUT('need a Xyzzy::Document object to run');

my $root = new_ok('Xyzzy::Request::Root', [env => {REQUEST_URI => '/', PATH_INFO => '/'}])
	or BAIL_OUT('need a Xyzzy::Request::Root object to run');

my $req = new_ok('Xyzzy::Request', [ctx => $root])
	or BAIL_OUT('need a Xyzzy::Request object to run');

my $doc = new_ok('Xyzzy::Document', [req => $req])
	or BAIL_OUT('need a Xyzzy::Document object to run');

my $cookie = $doc->bakecookie(foo => 3);

my $header = {$cookie->as_header->attributes};

is($header->{Path}, '/', "Ensure that cookie paths are never empty");

done_testing();
