use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Crypto::Config;

use Digest::SHA qw(sha256);
use Xyzzy::Util qw(parse_time);

use Xyzzy -self;

field cryptosecret => sub { die "no CryptoSecret configured\n" };
sub set_cryptosecret {
	my $key = shift;
	my $len = int(length($key)*2/3);
	my @values = (substr($key, 0, $len), substr($key, -$len));
	$self->cryptosecret([map { sha256($_) } @values]);
}

field cryptoclockjitter => 0;
sub set_cryptoclockjitter {
	$self->cryptoclockjitter(parse_time(shift));
}
