use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Document::Config;

use Clarity -self;

field templatedir => sub { die "TemplateDir not configured\n" };
field fragmentdir => sub { die "FragmentDir not configured\n" };
field contentdir => sub { die "ContentDir not configured\n" };
field stylesheetdir => sub { die "StylesheetDir not configured\n" };
field cache_stylesheets => 1;
field stylesheetcache => {};
field templatecache => {};
field fragmentcache => {};

sub set_templatedir {
	my $dir = shift;
	die "Missing argument to TemplateDir\n" unless defined $dir;
	stat $dir;
	warn "TemplateDir $dir doesn't exist\n" unless -e _;
	warn "TemplateDir $dir is not a directory\n" unless -d _;
	$self->templatedir($dir);
}

sub set_fragmentdir {
	my $dir = shift;
	die "Missing argument to FragmentDir\n" unless defined $dir;
	stat $dir;
	warn "FragmentDir $dir doesn't exist\n" unless -e _;
	warn "FragmentDir $dir is not a directory\n" unless -d _;
	$self->fragmentdir($dir);
}

sub set_contentdir {
	my $dir = shift;
	die "Missing argument to ContentDir\n" unless defined $dir;
	stat $dir;
	warn "ContentDir $dir doesn't exist\n" unless -e _;
	warn "ContentDir $dir is not a directory\n" unless -d _;
	$self->contentdir($dir);
}

sub set_stylesheetdir {
	my $dir = shift;
	die "Missing argument to StylesheetDir\n" unless defined $dir;
	stat $dir;
	warn "StylesheetDir $dir doesn't exist\n" unless -e _;
	warn "StylesheetDir $dir is not a directory\n" unless -d _;
	$self->stylesheetdir($dir);
}

sub set_cachestylesheets {
	$self->cache_stylesheets(Xyzzy::parse_bool(shift));
}

*set_cachetemplates = \&set_cachestylesheets;
