use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::ReST;

use Xyzzy::Fail;
use Xyzzy::ReST::Request;

use Xyzzy::Handler -self;

field generic => {};
field specific => {};
field fallback => sub { new Xyzzy::Fail(cfg => shift, code => 404) };

sub handle {
	my $req = new Xyzzy::ReST::Request(cfg => $self, ctx => shift);

	my $path = $req->path_components;

	return $self->handler->handle($req, @_)
		unless @$path;

	my $pairs = $req->pairs;

	my $entity = $pairs->[-2];
	my $value = $pairs->[-1];

	my $handlers = defined $value ? $self->specific : $self->generic;

	my $handler = $handlers->{$entity};
	return $self->fallback->handle($req, @_)
		unless $handler;

	return $handler->handle($req, @_);
}
