use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Static;

use Xyzzy::Handler -self;

field file => undef;
field contentdir => sub { shift->cfg->contentdir };
field static_stylesheet => sub { shift->cfg->static_stylesheet };

sub handle {
	my $req = new Xyzzy::Static::Request(ctx => shift, cfg => $self);
	my $doc = new Xyzzy::Static::Document(req => $req);

	return $doc->response;
}
