use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Directory::Request;

use Xyzzy::Util qw(utf8_testandset);

use Xyzzy::Request -self;

sub split_path() {
	return [map {
		utf8_testandset($_);
	} grep {
		$_ ne ''
	} split(qr{/+}, shift)];
}

field cwd => sub { eval { super } // [] };
field path_components => sub { eval { super } // split_path(shift->path_info) };
