use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::CAS;

use Xyzzy::Crypto;
use Xyzzy::CAS::Request;
use Xyzzy::CAS::Document;

use Xyzzy::Handler -self;

field login_url => sub { shift->cfg->cas_login_url };
field validate_url => sub { shift->cfg->cas_validate_url };
field crypto => sub { new Xyzzy::Crypto(cfg => shift->cfg) };
field snoop => undef;

sub handle {
	my $req = new Xyzzy::CAS::Request(ctx => shift, cfg => $self);

	if($req->valid_ticket) {
		my $doc = new Xyzzy::CAS::Document(req => $req);
		if($self->snoop) {
			my $res = eval { super($req, @_) };
			my $err = $@;
			if($err) {
				die $err unless UNIVERSAL::isa($err, 'Xyzzy::Response');
				$res = $err;
			}
			confess("internal error") unless $res;

			if($res->headers->{Location}) {
				$res->setcookie($doc->session_cookie);
				die $res if $err;
				return $res;
			}
		}
		die $doc->response;
	}

	if($req->cur_session ne $req->new_session) {
		my $res = eval { super($req, @_) };
		my $err = $@;
		if($err) {
			die $err unless UNIVERSAL::isa($err, 'Xyzzy::Response');
			$res = $err;
		}
		confess("internal error") unless $res;
		my $doc = new Xyzzy::CAS::Document(req => $req);
		$res->setcookie($doc->session_cookie);
		die $res if $err;
		return $res;
	}

	return super($req, @_);
}
