use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Method;

use Xyzzy::Fail;
use Xyzzy::Method::Request;

use Xyzzy::Handler -self;

field methods => {};

sub handle {
	my $req = new Xyzzy::Method::Request(cfg => $self, ctx => shift);

	my $method = $req->method;

	my $handler = $self->methods->{$method};
	return $self->handler->handle($req, @_)
		unless $handler;

	return $handler->handle($req, @_);
}
