#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Xyzzy qw(xyzzy_from_hash xyzzy_request xyzzy_request_as_cgi);

package Xyzzy::TestDumper;

use Xyzzy::Handler -self;

field id;

sub handle {
	my $req = shift;
	my $content = join("|",
		$self->id,
		join(':', eval { @{$req->cwd} }),
		join(':', @{$req->path_components}),
	);
	return new Xyzzy::Response(mimetype => 'text/plain', content => $content);
}

package main;

BEGIN { use_ok('Xyzzy::Directory') or BAIL_OUT('need Xyzzy::Directory to run') }

new_ok('Xyzzy::Directory') or BAIL_OUT('need a Xyzzy::Directory object to run');

my $cfg = new Xyzzy;

my $handler = new Xyzzy::Directory(cfg => $cfg,
	subdirs => {
		foo => new Xyzzy::Directory(cfg => $cfg,
			subdirs => {
				bar => new Xyzzy::TestDumper(cfg => $cfg, id => 0),
			},
			handler => new Xyzzy::TestDumper(cfg => $cfg, id => 1),
			fallback => new Xyzzy::TestDumper(cfg => $cfg, id => 2),
		),
	},
	handler => new Xyzzy::TestDumper(cfg => $cfg, id => 3),
	fallback => new Xyzzy::TestDumper(cfg => $cfg, id => 4),
);

isa_ok($handler, 'Xyzzy::Handler');

sub parse_cgi {
	my ($headers, $body) = split(/\015\012\015\012/, shift, 2);
	my @headers = split(/\015\012/, $headers);
	return $body, @headers;
}

foreach my $t (
	['/', '3||'],
	['/buzz', '4||buzz'],
	['/foo', '1|foo|'],
	['/foo/buzz', '2|foo|buzz'],
	['/foo/bar', '0|foo:bar|'],
	['/foo/bar/buzz', '0|foo:bar|buzz'],
) {
	my ($path, $expected) = @$t;
	my $res = xyzzy_request($handler, $path);
	is($res, $expected, "results for $path");
};

done_testing();
