use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Document::XHTML;

use Xyzzy::Document -self;

sub serialize {
	my $res = new Xyzzy::Response;

	if($self->req->msie) {
		$res->mimetype('text/html', charset => 'UTF-8');
		my $html = $self->toStringHTML;
		# elements marked F in http://www.w3.org/TR/html4/index/elements.html:
		$html =~ s{<((area|base(?:font)?|br|col|frame|hr|img|input|isindex|link|meta|param)(?: [^"'=<>]+=(?:"[^"]*"|'[^']*'))*)></\2>}{<$1 />}gi;
		$res->content($html);
	} else {
		$res->mimetype('application/xhtml+xml');
		$res->content($self->toString);
	}

	return $res;
}

sub build {
	$self->hook_next;
	foreach my $sheet (@{$self->cfg->xhtml_stylesheets}) {
		$self->transform($sheet);
	}
}
