use strict;
use warnings FATAL => 'all';

use Test::More;

use Exporter qw(import);
our @EXPORT_OK = qw(suicide survive carefully);
our @EXPORT = @EXPORT_OK;

sub survive(&$) {
	my ($func, $message) = @_;
	if(eval { $func->(); 1 }) {
		return 1;
	} else {
		return fail("$message: $@");
	}
}

sub suicide(&$$) {
	my ($func, $re, $message) = @_;
	my $res = eval { $func->() // 'undef' };
	if(defined $res) {
		return fail("$message: should have died but returned '$res'");
	} else {
		return $re ? like($@, $re, $message) : ok("$message: $@");
	}
}

sub carefully(&) {
	my $func = shift;
	my $res = eval { $func->() };
	return $res unless $@;
	warn $@;
	return undef;
}

__END__

=head1 Test::Xyzzy::Eval

This package provides functions to facilitate writing tests that need to be
robust against, or even require die/eval functionality. All functions are
exported by default.

=head2 survive($func, $message)

Tests whether $func->() survives being called.

=head2 suicide($func, $re, $message)

Tests whether $func->() dies after being called with the supplied arguments.

The exception is compared using regular expression $re (which may be undef if
you're not interested in the specific exception).

=head2 carefully($func)

Runs $func->(...) and catches any exceptions. If an exception is caught,
it will warn() it and return undef. Does not run any tests by itself.
