use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Directory;

use Xyzzy::Fail;
use Xyzzy::Directory::Request;

use Xyzzy::Handler -self;

field subdirs => {};
field fallback => sub { new Xyzzy::Fail(cfg => shift, code => 404) };

sub handle {
	my $ctx = shift;

	my $path = $ctx->path_components;

	return $self->handler->handle($ctx, @_)
		unless @$path;

	my $dir = $path->[0];

	my $handler = $self->subdirs->{$dir};
	return $self->fallback->handle($ctx, @_)
		unless $handler;

	my $req = new Xyzzy::Directory::Request(cfg => $self, ctx => $ctx);
	return $handler->handle($req, @_);
}
