use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Header;

use Clarity -self;

sub new {
	my @vals = @_;

	shift if @_ & 1;
	while(@_) {
		my $key = shift;
		my $val = shift;
		confess "Malformed header token '$key'"
			if defined $key && !istoken($key);
	}

	return bless(\@vals, $self);
}

sub unslash() {
	my $str = shift;
	return $str unless defined $str;
	local $1;
	$str =~ s/\\(.)/$1/g;
	return $str;
}

sub parse {
	my $str = shift;
	my @vals;
	push @vals, unslash($1) // $2
		if $str =~ s{^\s*+(?:"((?:\\.|[^"])*+)"|([^=;]*?))\s*(?:;\s*+|$)}{};
	$str =~ s{([^=;"]+)\s*+(?:=\s*+(?:"((?:\\.|[^"])*+)"|([^;]*?)))?\s*(?:;\s*+|$)}
		{push @vals, $1, unslash($2) // $3; ''}eg;
	return new Xyzzy::Header(@vals);
}

sub value {
	return undef unless @$self & 1;
	return $self->[0];
}

sub attributes {
	my @attrs = @$self;
	shift @attrs if @attrs & 1;
	return wantarray ? @attrs : \@attrs;
}

sub istoken() {
	return $_[0] =~ /^[!\#-'*.0-9A-Z^_\`a-z|-]+$/;
}

sub isnasty() {
	return $_[0] =~ /[^ -~]|^\s|\s$|\s\s|[;"]/;
}

sub toString {
	my @vals = @{$self};

	my @out;

	push @out, shift @vals
		if @vals & 1;

	while(@vals) {
		my $key = shift @vals;
		my $val = shift @vals;
		my $out = defined $key ? $key : '';
		if(defined $val) {
			if(isnasty($val)) {
				$val =~ s/(["\\])/\\$1/g;
				$val = "\"$val\"";
			}

			$out .= '='
				if defined $key;

			$out .= $val;
		}
		push @out, $out;
	}

	return join('; ', @out);
}

use overload
	'bool' => sub { 1 },
	'""' => \&toString,
	fallback => 1;
