use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Static::Request;

use Xyzzy::Request -self;
use Xyzzy::Util qw(uri_escape_auto);

field file => sub {
	my $self = shift;

	my $cfg = $self->cfg;

	my $path = $self->path_components;
	my $file = $cfg->file;
	if($file) {
		die $self->error(404) if @$path;
		$file = $cfg->contentdir . '/' . $file . '.xml'
			unless ord($file) == 47; # /
	} else {
		foreach(@$path) {
			unless(/^[a-z0-9]+([._,-]+[a-z0-9]+)*$/i) {
				my $info = join('/', map { uri_escape_auto($_) } @$path);
				die $self->error(403, "Bad path: '$info'");
			}
		}
		$path = ['index'] unless @$path;
		$file = join('/', $cfg->contentdir, @$path) . '.xml';
	}

	die $self->error(404) unless -f $file;
	die $self->error(403) unless -r _;

	return $file;
};
