#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Xyzzy qw(xyzzy_from_hash xyzzy_request xyzzy_request_as_cgi);

package Xyzzy::TestDumper;

use Xyzzy::Handler -self;

field id;

sub handle {
	my $req = shift;
	my $content = join("|",
		$self->id,
		join(':', eval { map { $_ // 'null' } @{$req->pairs} }),
		join(':', @{$req->path_components}),
	);
	return new Xyzzy::Response(mimetype => 'text/plain', content => $content);
}

package main;

BEGIN { use_ok('Xyzzy::ReST') or BAIL_OUT('need Xyzzy::ReST to run') }

new_ok('Xyzzy::ReST') or BAIL_OUT('need a Xyzzy::ReST object to run');

my $cfg = new Xyzzy;

my $handler = new Xyzzy::ReST(cfg => $cfg,
	generic => {
		foo => new Xyzzy::TestDumper(cfg => $cfg, id => 0),
	},
	specific => {
		foo => new Xyzzy::ReST(cfg => $cfg,
			generic => {
				bar => new Xyzzy::TestDumper(cfg => $cfg, id => 1),
			},
			specific => {
				bar => new Xyzzy::TestDumper(cfg => $cfg, id => 2),
			},
			handler => new Xyzzy::TestDumper(cfg => $cfg, id => 3),
			fallback => new Xyzzy::TestDumper(cfg => $cfg, id => 4),
		),
	},
	handler => new Xyzzy::TestDumper(cfg => $cfg, id => 5),
	fallback => new Xyzzy::TestDumper(cfg => $cfg, id => 6),
);

isa_ok($handler, 'Xyzzy::Handler');

sub parse_cgi {
	my ($headers, $body) = split(/\015\012\015\012/, shift, 2);
	my @headers = split(/\015\012/, $headers);
	return $body, @headers;
}

foreach my $t (
	['/', '5||'],
	['/buzz', '6||buzz'],
	['/foo', '0|foo:null|'],
	['/foo/x', '3|foo:x|'],
	['/foo/x/buzz', '4|foo:x|buzz'],
	['/foo/x/bar', '1|foo:x:bar:null|'],
	['/foo/x/bar/y', '2|foo:x:bar:y|'],
	['/foo/x/bar/y/buzz', '2|foo:x:bar:y|buzz'],
) {
	my ($path, $expected) = @$t;
	my $res = xyzzy_request($handler, $path);
	is($res, $expected, "results for $path");
};

done_testing();
