# $Id: Combined.pm 40788 2014-01-08 11:25:01Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Combined.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Combined;

use Aselect::UI::SPNEGO::Request;
use Aselect::UI::Password::Request;
use Aselect::UI::Password::Document;

use Aselect::Handler -self;
use Aselect::UI::SPNEGO -mixin;
use Aselect::UI::Password -mixin;

sub handle {
	my $req = shift;

	return if $req->gateway;

	my $passwd_req = new Aselect::UI::Password::Request(cfg => $self, ctx => $req);
	return $self->success->handle($passwd_req)
		if $passwd_req->uid;

	unless($req->renew
	|| defined $passwd_req->username
	|| defined $passwd_req->password
	|| $passwd_req->nonce) {
		my $spnego_req = new Aselect::UI::SPNEGO::Request(cfg => $self, ctx => $req);
		if($spnego_req->feasible) {
			return $self->success->handle($spnego_req)
				if $spnego_req->uid;
			if($spnego_req->spnego_uid) {
				$passwd_req->message('spnego-uid');
			} elsif($spnego_req->new_spnego eq 'true') {
				$passwd_req->message('spnego');
			}

			# hijack a password form so the user can fallback if spnego fails
			my $doc = new Aselect::UI::Password::Document(req => $passwd_req);
			my $res = $doc->response;
			$res->status(401);
			$res->addheader('WWW-Authenticate' => 'Negotiate');
			return $res;
		}
	}

	my $doc = new Aselect::UI::Password::Document(req => $passwd_req);
	return $doc->response;
}
