# $Id: Document.pm 42565 2014-11-17 14:06:46Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Document;

use Xyzzy::Util qw(iso8601);

use Xyzzy::Document::XHTML -self;

sub getStylesheet {
	my $lang = $self->req->lang
		or return super;
	my $file = shift;
	return super("$lang/$file", @_);
}

sub transform {
	return if $self->req->raw;
	return super;
}

sub build {
	my $name = $self->rootname;
	my $root = $self->construct($name);
	$self->setDocumentElement($root);

	$self->hook_next;

	$root = $self->documentElement;
	$name = $root->nodeName;

	my $cfg = $self->cfg;
	my $req = $self->req;
	$root->appendChild($self->construct(settings =>
		[warn => $req->new_warn],
		[remember => $req->new_remember],
		[spnego => $req->new_spnego],
	));

	my $ticket = $req->new_session;
	$root->appendChild($self->construct(nonce => scalar $ticket->create_nonce));

	if(my $uid = $ticket->uid) {
		my $exp = $ticket->expiration;

		$root->appendChild($self->construct(session =>
			[uid => $uid],
			[organization => $cfg->organization],
			[start => iso8601(gmtime($exp)) . ' GMT'],
			[end => iso8601(gmtime($exp + $cfg->session_timeout)) . ' GMT'],
		));
	}

	eval { $self->transform($name =~ tr|:|/|r) };
	warn $@ if $@;
}

sub bakecookie {
	my $cookie = super;
	if(my $domain = $self->cfg->cookiedomain) {
		$cookie->setparameter(Domain => $domain);
	}
	return $cookie;
}

sub response {
	my $res = super;
	my $req = $self->req;

	my $session = $req->new_session->token;
	my $previous = $req->cur_session;
	unless($previous && $previous->token eq $session) {
		my $cookie = $self->bakecookie(session => $session);
		$cookie->setparameter(HttpOnly => 1);
		$res->setcookie($cookie);
	}

	# intermediate proxies should not cache any page
	$res->addheader('Cache-Control' => 'private');

	my $sts = $self->cfg->strict_transport_security;
	$res->setheader('Strict-Transport-Security' => "max-age=$sts")
		if $sts && $req->https eq 'on';

	# DOM/XSL system protects against XSS
	$res->setheader('X-XSS-Protection' => 0);

	# Don't try to second guess the content type
	$res->setheader('X-Content-Type-Options' => 'nosniff');

	# Protect against clickjacking
	$res->setheader('X-Frame-Options' => 'DENY');

	$res->mimetype('application/xml')
		if $req->raw;

	return $res;
}
